/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber
public class TornadoPassiveSkills {
    private static final Random RANDOM = new Random();
    private static final float DASH_ACTIVATION_CHANCE = 0.3f;
    private static final int DASH_DURATION_TICKS = 200;
    private static final int DASH_COOLDOWN_TICKS = 800;
    private static final String PERSISTENT_DATA_KEY = "power";
    private static final String LAST_ACTIVATION_TICK_KEY = "tornado_last_activation";

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        Level level = event.getEntity().level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        LivingEntity target = event.getEntity();
        ServerPlayer attacker = null;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer sp;
            attacker = sp = (ServerPlayer)entity;
        } else {
            entity = event.getSource().getDirectEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer sp;
                attacker = sp = (ServerPlayer)entity;
            }
        }
        if (attacker == null) {
            return;
        }
        if (!attacker.hasEffect(PowerModMobEffects.TORNADO_MASTER)) {
            return;
        }
        if (!TornadoPassiveSkills.isPlayerInOpenArea(attacker)) {
            return;
        }
        if (RANDOM.nextFloat() < 0.15f) {
            target.setDeltaMovement(target.getDeltaMovement().x(), 0.8, target.getDeltaMovement().z());
            target.hurtMarked = true;
        }
        if (RANDOM.nextFloat() < 0.3f) {
            CompoundTag persistentData = attacker.getPersistentData();
            CompoundTag modData = persistentData.getCompound(PERSISTENT_DATA_KEY);
            int currentTick = (int)attacker.level().getGameTime();
            int lastActivationTick = modData.getInt(LAST_ACTIVATION_TICK_KEY);
            if (lastActivationTick + 800 <= currentTick) {
                attacker.addEffect(new MobEffectInstance(PowerModMobEffects.DASH, 200, 1, false, true, true));
                modData.putInt(LAST_ACTIVATION_TICK_KEY, currentTick);
                persistentData.put(PERSISTENT_DATA_KEY, (Tag)modData);
            }
        }
    }

    private static boolean isPlayerInOpenArea(ServerPlayer player) {
        return player.level().canSeeSky(player.blockPosition().above());
    }
}

