/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo.network;

import com.esmods.keepersofthestonestwo.PowerMod;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber
public class PowerModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"power");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        PowerMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        PowerMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    @SubscribeEvent
    public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerTickUpdateSyncPlayerVariables(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (((PlayerVariables)player2.getData(PowerModVariables.PLAYER_VARIABLES))._syncDirty) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((PlayerVariables)player2.getData(PowerModVariables.PLAYER_VARIABLES))._syncDirty = false;
            }
        }
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
        PlayerVariables clone = new PlayerVariables();
        clone.ability = original.ability;
        clone.element_name_first = original.element_name_first;
        clone.element_name_second = original.element_name_second;
        clone.element_name_third = original.element_name_third;
        clone.fake_element_name_first = original.fake_element_name_first;
        clone.fake_element_name_second = original.fake_element_name_second;
        clone.fake_element_name_third = original.fake_element_name_third;
        clone.max_power = original.max_power;
        clone.recharge_timer = original.recharge_timer;
        clone.master_effect_duration = original.master_effect_duration;
        clone.selected = original.selected;
        clone.active_battery = original.active_battery;
        clone.debug = original.debug;
        clone.helmet = original.helmet;
        clone.chestplate = original.chestplate;
        clone.leggings = original.leggings;
        clone.boots = original.boots;
        clone.unlock_keepers_box = original.unlock_keepers_box;
        clone.level = original.level;
        clone.level_exp = original.level_exp;
        clone.base_damage_by_lvl = original.base_damage_by_lvl;
        clone.max_level_exp = original.max_level_exp;
        clone.resistance_char = original.resistance_char;
        clone.speed_char = original.speed_char;
        clone.haste_char = original.haste_char;
        clone.jump_char = original.jump_char;
        clone.rank = original.rank;
        clone.mind_used = original.mind_used;
        clone.blue_rune_slot = original.blue_rune_slot;
        clone.red_rune_slot = original.red_rune_slot;
        clone.green_rune_slot = original.green_rune_slot;
        clone.conv_to_new_rune_system = original.conv_to_new_rune_system;
        clone.rune_ability_activate = original.rune_ability_activate;
        if (!event.isWasDeath()) {
            clone.teleporting_effect = original.teleporting_effect;
            clone.abilities_timer = original.abilities_timer;
            clone.fake_element_name_first_timer = original.fake_element_name_first_timer;
            clone.fake_element_name_second_timer = original.fake_element_name_second_timer;
            clone.fake_element_name_third_timer = original.fake_element_name_third_timer;
            clone.power = original.power;
            clone.powerTimer = original.powerTimer;
            clone.mergers = original.mergers;
            clone.power_recovery_multiplier = original.power_recovery_multiplier;
            clone.active_power = original.active_power;
            clone.ability_block = original.ability_block;
            clone.use_ability_key_var = original.use_ability_key_var;
            clone.detransf_key_var = original.detransf_key_var;
            clone.wheel_open_key_var = original.wheel_open_key_var;
            clone.second_wheel_open_var = original.second_wheel_open_var;
            clone.third_wheel_open_var = original.third_wheel_open_var;
            clone.first_fake_wheel_open_var = original.first_fake_wheel_open_var;
            clone.second_fake_wheel_open_var = original.second_fake_wheel_open_var;
            clone.third_fake_wheel_open_var = original.third_fake_wheel_open_var;
            clone.ability_using = original.ability_using;
            clone.power_recorded = original.power_recorded;
            clone.detransform_anim_trigger = original.detransform_anim_trigger;
            clone.transfered_power = original.transfered_power;
            clone.master_effect_end = original.master_effect_end;
            clone.master_effect_start = original.master_effect_start;
            clone.level_up_status = original.level_up_status;
            clone.mind_player_owner = original.mind_player_owner;
        }
        event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
            WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
            if (mapdata != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (worlddata != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
            if (worlddata != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            WorldVariables worldVariables = WorldVariables.get((LevelAccessor)level2);
            if (worldVariables._syncDirty) {
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level2, (CustomPacketPayload)new SavedDataSyncMessage(1, worldVariables), (CustomPacketPayload[])new CustomPacketPayload[0]);
                worldVariables._syncDirty = false;
            }
            MapVariables mapVariables = MapVariables.get((LevelAccessor)level2);
            if (mapVariables._syncDirty) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, mapVariables), (CustomPacketPayload[])new CustomPacketPayload[0]);
                mapVariables._syncDirty = false;
            }
        }
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"power", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"power", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        boolean _syncDirty = false;
        public String ability = "0";
        public String element_name_first = "0";
        public String element_name_second = "0";
        public String element_name_third = "0";
        public double teleporting_effect = 0.0;
        public String fake_element_name_first = "0";
        public String fake_element_name_second = "0";
        public String fake_element_name_third = "0";
        public double abilities_timer = 0.0;
        public double fake_element_name_first_timer = 0.0;
        public double fake_element_name_second_timer = 0.0;
        public double fake_element_name_third_timer = 0.0;
        public double power = 0.0;
        public double powerTimer = 0.0;
        public double mergers = 0.0;
        public double power_recovery_multiplier = 1.0;
        public double max_power = 100.0;
        public double recharge_timer = 300.0;
        public double master_effect_duration = 600.0;
        public boolean active_power = false;
        public boolean selected = false;
        public boolean active_battery = false;
        public boolean ability_block = false;
        public boolean use_ability_key_var = false;
        public boolean detransf_key_var = false;
        public boolean wheel_open_key_var = false;
        public boolean second_wheel_open_var = false;
        public boolean third_wheel_open_var = false;
        public boolean first_fake_wheel_open_var = false;
        public boolean second_fake_wheel_open_var = false;
        public boolean third_fake_wheel_open_var = false;
        public boolean ability_using = false;
        public boolean power_recorded = false;
        public boolean debug = false;
        public boolean detransform_anim_trigger = false;
        public ItemStack helmet = ItemStack.EMPTY;
        public ItemStack chestplate = ItemStack.EMPTY;
        public ItemStack leggings = ItemStack.EMPTY;
        public ItemStack boots = ItemStack.EMPTY;
        public boolean unlock_keepers_box = false;
        public boolean transfered_power = false;
        public boolean master_effect_end = false;
        public boolean master_effect_start = false;
        public double level = 1.0;
        public double level_exp = 0.0;
        public double base_damage_by_lvl = 6.0;
        public double max_level_exp = 100.0;
        public double resistance_char = 0.0;
        public double speed_char = 1.0;
        public double haste_char = -1.0;
        public double jump_char = 1.0;
        public boolean level_up_status = false;
        public String rank = "D";
        public String mind_player_owner = "\"\"";
        public boolean mind_used = false;
        public ItemStack blue_rune_slot = ItemStack.EMPTY;
        public ItemStack red_rune_slot = ItemStack.EMPTY;
        public ItemStack green_rune_slot = ItemStack.EMPTY;
        public boolean conv_to_new_rune_system = true;
        public boolean rune_ability_activate = false;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putString("ability", this.ability);
            nbt.putString("element_name_first", this.element_name_first);
            nbt.putString("element_name_second", this.element_name_second);
            nbt.putString("element_name_third", this.element_name_third);
            nbt.putDouble("teleporting_effect", this.teleporting_effect);
            nbt.putString("fake_element_name_first", this.fake_element_name_first);
            nbt.putString("fake_element_name_second", this.fake_element_name_second);
            nbt.putString("fake_element_name_third", this.fake_element_name_third);
            nbt.putDouble("abilities_timer", this.abilities_timer);
            nbt.putDouble("fake_element_name_first_timer", this.fake_element_name_first_timer);
            nbt.putDouble("fake_element_name_second_timer", this.fake_element_name_second_timer);
            nbt.putDouble("fake_element_name_third_timer", this.fake_element_name_third_timer);
            nbt.putDouble("power", this.power);
            nbt.putDouble("powerTimer", this.powerTimer);
            nbt.putDouble("mergers", this.mergers);
            nbt.putDouble("power_recovery_multiplier", this.power_recovery_multiplier);
            nbt.putDouble("max_power", this.max_power);
            nbt.putDouble("recharge_timer", this.recharge_timer);
            nbt.putDouble("master_effect_duration", this.master_effect_duration);
            nbt.putBoolean("active_power", this.active_power);
            nbt.putBoolean("selected", this.selected);
            nbt.putBoolean("active_battery", this.active_battery);
            nbt.putBoolean("ability_block", this.ability_block);
            nbt.putBoolean("use_ability_key_var", this.use_ability_key_var);
            nbt.putBoolean("detransf_key_var", this.detransf_key_var);
            nbt.putBoolean("wheel_open_key_var", this.wheel_open_key_var);
            nbt.putBoolean("second_wheel_open_var", this.second_wheel_open_var);
            nbt.putBoolean("third_wheel_open_var", this.third_wheel_open_var);
            nbt.putBoolean("first_fake_wheel_open_var", this.first_fake_wheel_open_var);
            nbt.putBoolean("second_fake_wheel_open_var", this.second_fake_wheel_open_var);
            nbt.putBoolean("third_fake_wheel_open_var", this.third_fake_wheel_open_var);
            nbt.putBoolean("ability_using", this.ability_using);
            nbt.putBoolean("power_recorded", this.power_recorded);
            nbt.putBoolean("debug", this.debug);
            nbt.putBoolean("detransform_anim_trigger", this.detransform_anim_trigger);
            nbt.put("helmet", this.helmet.saveOptional(lookupProvider));
            nbt.put("chestplate", this.chestplate.saveOptional(lookupProvider));
            nbt.put("leggings", this.leggings.saveOptional(lookupProvider));
            nbt.put("boots", this.boots.saveOptional(lookupProvider));
            nbt.putBoolean("unlock_keepers_box", this.unlock_keepers_box);
            nbt.putBoolean("transfered_power", this.transfered_power);
            nbt.putBoolean("master_effect_end", this.master_effect_end);
            nbt.putBoolean("master_effect_start", this.master_effect_start);
            nbt.putDouble("level", this.level);
            nbt.putDouble("level_exp", this.level_exp);
            nbt.putDouble("base_damage_by_lvl", this.base_damage_by_lvl);
            nbt.putDouble("max_level_exp", this.max_level_exp);
            nbt.putDouble("resistance_char", this.resistance_char);
            nbt.putDouble("speed_char", this.speed_char);
            nbt.putDouble("haste_char", this.haste_char);
            nbt.putDouble("jump_char", this.jump_char);
            nbt.putBoolean("level_up_status", this.level_up_status);
            nbt.putString("rank", this.rank);
            nbt.putString("mind_player_owner", this.mind_player_owner);
            nbt.putBoolean("mind_used", this.mind_used);
            nbt.put("blue_rune_slot", this.blue_rune_slot.saveOptional(lookupProvider));
            nbt.put("red_rune_slot", this.red_rune_slot.saveOptional(lookupProvider));
            nbt.put("green_rune_slot", this.green_rune_slot.saveOptional(lookupProvider));
            nbt.putBoolean("conv_to_new_rune_system", this.conv_to_new_rune_system);
            nbt.putBoolean("rune_ability_activate", this.rune_ability_activate);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.ability = nbt.getString("ability");
            this.element_name_first = nbt.getString("element_name_first");
            this.element_name_second = nbt.getString("element_name_second");
            this.element_name_third = nbt.getString("element_name_third");
            this.teleporting_effect = nbt.getDouble("teleporting_effect");
            this.fake_element_name_first = nbt.getString("fake_element_name_first");
            this.fake_element_name_second = nbt.getString("fake_element_name_second");
            this.fake_element_name_third = nbt.getString("fake_element_name_third");
            this.abilities_timer = nbt.getDouble("abilities_timer");
            this.fake_element_name_first_timer = nbt.getDouble("fake_element_name_first_timer");
            this.fake_element_name_second_timer = nbt.getDouble("fake_element_name_second_timer");
            this.fake_element_name_third_timer = nbt.getDouble("fake_element_name_third_timer");
            this.power = nbt.getDouble("power");
            this.powerTimer = nbt.getDouble("powerTimer");
            this.mergers = nbt.getDouble("mergers");
            this.power_recovery_multiplier = nbt.getDouble("power_recovery_multiplier");
            this.max_power = nbt.getDouble("max_power");
            this.recharge_timer = nbt.getDouble("recharge_timer");
            this.master_effect_duration = nbt.getDouble("master_effect_duration");
            this.active_power = nbt.getBoolean("active_power");
            this.selected = nbt.getBoolean("selected");
            this.active_battery = nbt.getBoolean("active_battery");
            this.ability_block = nbt.getBoolean("ability_block");
            this.use_ability_key_var = nbt.getBoolean("use_ability_key_var");
            this.detransf_key_var = nbt.getBoolean("detransf_key_var");
            this.wheel_open_key_var = nbt.getBoolean("wheel_open_key_var");
            this.second_wheel_open_var = nbt.getBoolean("second_wheel_open_var");
            this.third_wheel_open_var = nbt.getBoolean("third_wheel_open_var");
            this.first_fake_wheel_open_var = nbt.getBoolean("first_fake_wheel_open_var");
            this.second_fake_wheel_open_var = nbt.getBoolean("second_fake_wheel_open_var");
            this.third_fake_wheel_open_var = nbt.getBoolean("third_fake_wheel_open_var");
            this.ability_using = nbt.getBoolean("ability_using");
            this.power_recorded = nbt.getBoolean("power_recorded");
            this.debug = nbt.getBoolean("debug");
            this.detransform_anim_trigger = nbt.getBoolean("detransform_anim_trigger");
            this.helmet = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("helmet"));
            this.chestplate = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("chestplate"));
            this.leggings = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("leggings"));
            this.boots = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("boots"));
            this.unlock_keepers_box = nbt.getBoolean("unlock_keepers_box");
            this.transfered_power = nbt.getBoolean("transfered_power");
            this.master_effect_end = nbt.getBoolean("master_effect_end");
            this.master_effect_start = nbt.getBoolean("master_effect_start");
            this.level = nbt.getDouble("level");
            this.level_exp = nbt.getDouble("level_exp");
            this.base_damage_by_lvl = nbt.getDouble("base_damage_by_lvl");
            this.max_level_exp = nbt.getDouble("max_level_exp");
            this.resistance_char = nbt.getDouble("resistance_char");
            this.speed_char = nbt.getDouble("speed_char");
            this.haste_char = nbt.getDouble("haste_char");
            this.jump_char = nbt.getDouble("jump_char");
            this.level_up_status = nbt.getBoolean("level_up_status");
            this.rank = nbt.getString("rank");
            this.mind_player_owner = nbt.getString("mind_player_owner");
            this.mind_used = nbt.getBoolean("mind_used");
            this.blue_rune_slot = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("blue_rune_slot"));
            this.red_rune_slot = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("red_rune_slot"));
            this.green_rune_slot = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("green_rune_slot"));
            this.conv_to_new_rune_system = nbt.getBoolean("conv_to_new_rune_system");
            this.rune_ability_activate = nbt.getBoolean("rune_ability_activate");
        }

        public void markSyncDirty() {
            this._syncDirty = true;
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "power_mapvars";
        boolean _syncDirty = false;
        public double opX = 0.0;
        public double opY = 0.0;
        public double opZ = 0.0;
        public double bpX = 0.0;
        public double bpY = 0.0;
        public double bpZ = 0.0;
        public boolean fire_stone = false;
        public boolean air_stone = false;
        public boolean earth_stone = false;
        public boolean water_stone = false;
        public boolean ether_stone = false;
        public boolean ice_stone = false;
        public boolean lightning_stone = false;
        public boolean sound_stone = false;
        public boolean crystal_stone = false;
        public boolean lava_stone = false;
        public boolean rain_stone = false;
        public boolean tornado_stone = false;
        public boolean ocean_stone = false;
        public boolean plants_stone = false;
        public boolean animals_stone = false;
        public boolean metal_stone = false;
        public boolean light_stone = false;
        public boolean shadow_stone = false;
        public boolean vacuum_stone = false;
        public boolean energy_stone = false;
        public boolean sun_stone = false;
        public boolean moon_stone = false;
        public boolean space_stone = false;
        public boolean time_stone = false;
        public boolean blood_stone = false;
        public boolean technology_stone = false;
        public boolean teleportation_stone = false;
        public boolean explosion_stone = false;
        public boolean amber_stone = false;
        public boolean creation_stone = false;
        public boolean destruction_stone = false;
        public boolean mist_stone = false;
        public boolean sand_stone = false;
        public boolean speed_stone = false;
        public boolean poison_stone = false;
        public boolean magnet_stone = false;
        public boolean mushrooms_stone = false;
        public boolean mercury_stone = false;
        public boolean music_stone = false;
        public boolean plague_stone = false;
        public boolean blue_flame_stone = false;
        public boolean gravity_stone = false;
        public boolean smoke_stone = false;
        public boolean spirit_stone = false;
        public boolean form_stone = false;
        public boolean mind_stone = false;
        public boolean golden_dust_stone = false;
        public boolean darkness_stone = false;
        public boolean blue_portal_placed = false;
        public boolean orange_portal_placed = false;
        public double cpapi_ver = 28.0;
        public boolean heat_stone = false;
        public boolean shockwave_stone = false;
        public boolean colors_stone = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.opX = nbt.getDouble("opX");
            this.opY = nbt.getDouble("opY");
            this.opZ = nbt.getDouble("opZ");
            this.bpX = nbt.getDouble("bpX");
            this.bpY = nbt.getDouble("bpY");
            this.bpZ = nbt.getDouble("bpZ");
            this.fire_stone = nbt.getBoolean("fire_stone");
            this.air_stone = nbt.getBoolean("air_stone");
            this.earth_stone = nbt.getBoolean("earth_stone");
            this.water_stone = nbt.getBoolean("water_stone");
            this.ether_stone = nbt.getBoolean("ether_stone");
            this.ice_stone = nbt.getBoolean("ice_stone");
            this.lightning_stone = nbt.getBoolean("lightning_stone");
            this.sound_stone = nbt.getBoolean("sound_stone");
            this.crystal_stone = nbt.getBoolean("crystal_stone");
            this.lava_stone = nbt.getBoolean("lava_stone");
            this.rain_stone = nbt.getBoolean("rain_stone");
            this.tornado_stone = nbt.getBoolean("tornado_stone");
            this.ocean_stone = nbt.getBoolean("ocean_stone");
            this.plants_stone = nbt.getBoolean("plants_stone");
            this.animals_stone = nbt.getBoolean("animals_stone");
            this.metal_stone = nbt.getBoolean("metal_stone");
            this.light_stone = nbt.getBoolean("light_stone");
            this.shadow_stone = nbt.getBoolean("shadow_stone");
            this.vacuum_stone = nbt.getBoolean("vacuum_stone");
            this.energy_stone = nbt.getBoolean("energy_stone");
            this.sun_stone = nbt.getBoolean("sun_stone");
            this.moon_stone = nbt.getBoolean("moon_stone");
            this.space_stone = nbt.getBoolean("space_stone");
            this.time_stone = nbt.getBoolean("time_stone");
            this.blood_stone = nbt.getBoolean("blood_stone");
            this.technology_stone = nbt.getBoolean("technology_stone");
            this.teleportation_stone = nbt.getBoolean("teleportation_stone");
            this.explosion_stone = nbt.getBoolean("explosion_stone");
            this.amber_stone = nbt.getBoolean("amber_stone");
            this.creation_stone = nbt.getBoolean("creation_stone");
            this.destruction_stone = nbt.getBoolean("destruction_stone");
            this.mist_stone = nbt.getBoolean("mist_stone");
            this.sand_stone = nbt.getBoolean("sand_stone");
            this.speed_stone = nbt.getBoolean("speed_stone");
            this.poison_stone = nbt.getBoolean("poison_stone");
            this.magnet_stone = nbt.getBoolean("magnet_stone");
            this.mushrooms_stone = nbt.getBoolean("mushrooms_stone");
            this.mercury_stone = nbt.getBoolean("mercury_stone");
            this.music_stone = nbt.getBoolean("music_stone");
            this.plague_stone = nbt.getBoolean("plague_stone");
            this.blue_flame_stone = nbt.getBoolean("blue_flame_stone");
            this.gravity_stone = nbt.getBoolean("gravity_stone");
            this.smoke_stone = nbt.getBoolean("smoke_stone");
            this.spirit_stone = nbt.getBoolean("spirit_stone");
            this.form_stone = nbt.getBoolean("form_stone");
            this.mind_stone = nbt.getBoolean("mind_stone");
            this.golden_dust_stone = nbt.getBoolean("golden_dust_stone");
            this.darkness_stone = nbt.getBoolean("darkness_stone");
            this.blue_portal_placed = nbt.getBoolean("blue_portal_placed");
            this.orange_portal_placed = nbt.getBoolean("orange_portal_placed");
            this.cpapi_ver = nbt.getDouble("cpapi_ver");
            this.heat_stone = nbt.getBoolean("heat_stone");
            this.shockwave_stone = nbt.getBoolean("shockwave_stone");
            this.colors_stone = nbt.getBoolean("colors_stone");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("opX", this.opX);
            nbt.putDouble("opY", this.opY);
            nbt.putDouble("opZ", this.opZ);
            nbt.putDouble("bpX", this.bpX);
            nbt.putDouble("bpY", this.bpY);
            nbt.putDouble("bpZ", this.bpZ);
            nbt.putBoolean("fire_stone", this.fire_stone);
            nbt.putBoolean("air_stone", this.air_stone);
            nbt.putBoolean("earth_stone", this.earth_stone);
            nbt.putBoolean("water_stone", this.water_stone);
            nbt.putBoolean("ether_stone", this.ether_stone);
            nbt.putBoolean("ice_stone", this.ice_stone);
            nbt.putBoolean("lightning_stone", this.lightning_stone);
            nbt.putBoolean("sound_stone", this.sound_stone);
            nbt.putBoolean("crystal_stone", this.crystal_stone);
            nbt.putBoolean("lava_stone", this.lava_stone);
            nbt.putBoolean("rain_stone", this.rain_stone);
            nbt.putBoolean("tornado_stone", this.tornado_stone);
            nbt.putBoolean("ocean_stone", this.ocean_stone);
            nbt.putBoolean("plants_stone", this.plants_stone);
            nbt.putBoolean("animals_stone", this.animals_stone);
            nbt.putBoolean("metal_stone", this.metal_stone);
            nbt.putBoolean("light_stone", this.light_stone);
            nbt.putBoolean("shadow_stone", this.shadow_stone);
            nbt.putBoolean("vacuum_stone", this.vacuum_stone);
            nbt.putBoolean("energy_stone", this.energy_stone);
            nbt.putBoolean("sun_stone", this.sun_stone);
            nbt.putBoolean("moon_stone", this.moon_stone);
            nbt.putBoolean("space_stone", this.space_stone);
            nbt.putBoolean("time_stone", this.time_stone);
            nbt.putBoolean("blood_stone", this.blood_stone);
            nbt.putBoolean("technology_stone", this.technology_stone);
            nbt.putBoolean("teleportation_stone", this.teleportation_stone);
            nbt.putBoolean("explosion_stone", this.explosion_stone);
            nbt.putBoolean("amber_stone", this.amber_stone);
            nbt.putBoolean("creation_stone", this.creation_stone);
            nbt.putBoolean("destruction_stone", this.destruction_stone);
            nbt.putBoolean("mist_stone", this.mist_stone);
            nbt.putBoolean("sand_stone", this.sand_stone);
            nbt.putBoolean("speed_stone", this.speed_stone);
            nbt.putBoolean("poison_stone", this.poison_stone);
            nbt.putBoolean("magnet_stone", this.magnet_stone);
            nbt.putBoolean("mushrooms_stone", this.mushrooms_stone);
            nbt.putBoolean("mercury_stone", this.mercury_stone);
            nbt.putBoolean("music_stone", this.music_stone);
            nbt.putBoolean("plague_stone", this.plague_stone);
            nbt.putBoolean("blue_flame_stone", this.blue_flame_stone);
            nbt.putBoolean("gravity_stone", this.gravity_stone);
            nbt.putBoolean("smoke_stone", this.smoke_stone);
            nbt.putBoolean("spirit_stone", this.spirit_stone);
            nbt.putBoolean("form_stone", this.form_stone);
            nbt.putBoolean("mind_stone", this.mind_stone);
            nbt.putBoolean("golden_dust_stone", this.golden_dust_stone);
            nbt.putBoolean("darkness_stone", this.darkness_stone);
            nbt.putBoolean("blue_portal_placed", this.blue_portal_placed);
            nbt.putBoolean("orange_portal_placed", this.orange_portal_placed);
            nbt.putDouble("cpapi_ver", this.cpapi_ver);
            nbt.putBoolean("heat_stone", this.heat_stone);
            nbt.putBoolean("shockwave_stone", this.shockwave_stone);
            nbt.putBoolean("colors_stone", this.colors_stone);
            return nbt;
        }

        public void markSyncDirty() {
            this.setDirty();
            this._syncDirty = true;
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "power_worldvars";
        boolean _syncDirty = false;
        public double entity_rotation = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.entity_rotation = nbt.getDouble("entity_rotation");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("entity_rotation", this.entity_rotation);
            return nbt;
        }

        public void markSyncDirty() {
            this.setDirty();
            this._syncDirty = true;
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }
}

