/*
 * Decompiled with CFR 0.152.
 */
package your.modid.common.event;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

@EventBusSubscriber
public class ExplosionPassiveSkills {
    private static boolean isActive(Player player) {
        if (player.level().isClientSide()) {
            return false;
        }
        if (!player.hasEffect(PowerModMobEffects.EXPLOSION_MASTER)) {
            return false;
        }
        return player.getInventory().contains(new ItemStack((ItemLike)Items.TNT)) || player.getInventory().contains(new ItemStack((ItemLike)Items.GUNPOWDER));
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        if (!ExplosionPassiveSkills.isActive(attacker)) {
            return;
        }
        event.setNewDamage(event.getOriginalDamage() * 1.2f);
    }

    @SubscribeEvent
    public static void onPlayerKilledByEntity(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!ExplosionPassiveSkills.isActive(player)) {
            return;
        }
        DamageSource source = event.getSource();
        Entity attacker = source.getEntity();
        if (attacker instanceof LivingEntity && attacker != player) {
            ExplosionPassiveSkills.explodePlayer(player);
        }
    }

    @SubscribeEvent
    public static void onExplosionDamage(LivingIncomingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!ExplosionPassiveSkills.isActive(player)) {
            return;
        }
        if (event.getSource().is(DamageTypes.EXPLOSION)) {
            event.setCanceled(true);
        }
    }

    private static void explodePlayer(Player player) {
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.explode((Entity)player, player.getX(), player.getY(), player.getZ(), 3.0f, Level.ExplosionInteraction.MOB);
        }
    }
}

