/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.api;

import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import net.minecraft.resources.ResourceLocation;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.ScaleRegistries;

public final class ScaleEasings {
    private static final double HALF_PI = 1.5707963267948966;
    public static final Float2FloatFunction LINEAR = ScaleEasings.register("linear", x -> x);
    public static final Float2FloatFunction QUADRATIC_IN = ScaleEasings.register("quadratic_in", x -> x * x);
    public static final Float2FloatFunction QUADRATIC_OUT = ScaleEasings.register("quadratic_out", x -> -(x * (x - 2.0f)));
    public static final Float2FloatFunction QUADRATIC_IN_OUT = ScaleEasings.register("quadratic_in_out", x -> {
        if (x < 0.5f) {
            return 2.0f * x * x;
        }
        return -2.0f * x * x + 4.0f * x - 1.0f;
    });
    public static final Float2FloatFunction CUBIC_IN = ScaleEasings.register("cubic_in", x -> x * x * x);
    public static final Float2FloatFunction CUBIC_OUT = ScaleEasings.register("cubic_out", x -> {
        float f = x - 1.0f;
        return f * f * f + 1.0f;
    });
    public static final Float2FloatFunction CUBIC_IN_OUT = ScaleEasings.register("cubic_in_out", x -> {
        if (x < 0.5f) {
            return 4.0f * x * x * x;
        }
        float f = 2.0f * x - 2.0f;
        return 0.5f * f * f * f + 1.0f;
    });
    public static final Float2FloatFunction QUARTIC_IN = ScaleEasings.register("quartic_in", x -> x * x * x * x);
    public static final Float2FloatFunction QUARTIC_OUT = ScaleEasings.register("quartic_out", x -> {
        float f = x - 1.0f;
        return f * f * f * (1.0f - x) + 1.0f;
    });
    public static final Float2FloatFunction QUARTIC_IN_OUT = ScaleEasings.register("quartic_in_out", x -> {
        if (x < 0.5f) {
            return 8.0f * x * x * x * x;
        }
        float f = x - 1.0f;
        return -8.0f * f * f * f * f + 1.0f;
    });
    public static final Float2FloatFunction QUINTIC_IN = ScaleEasings.register("quintic_in", x -> x * x * x * x * x);
    public static final Float2FloatFunction QUINTIC_OUT = ScaleEasings.register("quintic_out", x -> {
        float f = x - 1.0f;
        return f * f * f * f * f + 1.0f;
    });
    public static final Float2FloatFunction QUINTIC_IN_OUT = ScaleEasings.register("quintic_in_out", x -> {
        if (x < 0.5f) {
            return 16.0f * x * x * x * x * x;
        }
        float f = 2.0f * x - 2.0f;
        return 0.5f * f * f * f * f * f + 1.0f;
    });
    public static final Float2FloatFunction SINE_IN = ScaleEasings.register("sine_in", x -> (float)Math.sin((double)(x - 1.0f) * 1.5707963267948966) + 1.0f);
    public static final Float2FloatFunction SINE_OUT = ScaleEasings.register("sine_out", x -> (float)Math.sin((double)x * 1.5707963267948966));
    public static final Float2FloatFunction SINE_IN_OUT = ScaleEasings.register("sine_in_out", x -> (float)(0.5 * (1.0 - Math.cos((double)x * Math.PI))));
    public static final Float2FloatFunction CIRCULAR_IN = ScaleEasings.register("circular_in", x -> (float)(1.0 - Math.sqrt(1.0f - x * x)));
    public static final Float2FloatFunction CIRCULAR_OUT = ScaleEasings.register("circular_out", x -> (float)Math.sqrt((2.0f - x) * x));
    public static final Float2FloatFunction CIRCULAR_IN_OUT = ScaleEasings.register("circular_in_out", x -> {
        if (x < 0.5f) {
            return (float)(0.5 * (1.0 - Math.sqrt(1.0f - 4.0f * x * x)));
        }
        return (float)(0.5 * (Math.sqrt(1.0f - 4.0f * (1.0f - x) * (1.0f - x)) + 1.0));
    });
    public static final Float2FloatFunction EXPONENTIAL_IN = ScaleEasings.register("exponential_in", x -> (float)(x == 0.0f ? (double)x : Math.pow(2.0, 10.0f * (x - 1.0f))));
    public static final Float2FloatFunction EXPONENTIAL_OUT = ScaleEasings.register("exponential_out", x -> (float)(x == 1.0f ? (double)x : 1.0 - Math.pow(2.0, -10.0f * x)));
    public static final Float2FloatFunction EXPONENTIAL_IN_OUT = ScaleEasings.register("exponential_in_out", x -> {
        if (x == 0.0f || x == 1.0f) {
            return x;
        }
        if (x < 0.5f) {
            return (float)(0.5 * Math.pow(2.0, 20.0f * x - 10.0f));
        }
        return (float)(-0.5 * Math.pow(2.0, -20.0f * x + 10.0f) + 1.0);
    });
    public static final Float2FloatFunction ELASTIC_IN = ScaleEasings.register("elastic_in", x -> (float)(Math.sin(20.420352248333657 * (double)x) * Math.pow(2.0, 10.0f * (x - 1.0f))));
    public static final Float2FloatFunction ELASTIC_OUT = ScaleEasings.register("elastic_out", x -> (float)(Math.sin(-20.420352248333657 * (double)(x + 1.0f)) * Math.pow(2.0, -10.0f * x) + 1.0));
    public static final Float2FloatFunction ELASTIC_IN_OUT = ScaleEasings.register("elastic_in_out", x -> {
        if (x < 0.5f) {
            return (float)(0.5 * Math.sin(20.420352248333657 * (double)(2.0f * x)) * Math.pow(2.0, 10.0f * (2.0f * x - 1.0f)));
        }
        return (float)(0.5 * (Math.sin(-20.420352248333657 * (double)(2.0f * x - 1.0f + 1.0f)) * Math.pow(2.0, -10.0f * (2.0f * x - 1.0f)) + 2.0));
    });
    public static final Float2FloatFunction BACK_IN = ScaleEasings.register("back_in", x -> (float)((double)(x * x * x) - (double)x * Math.sin((double)x * Math.PI)));
    public static final Float2FloatFunction BACK_OUT = ScaleEasings.register("back_out", x -> {
        float f = 1.0f - x;
        return (float)(1.0 - ((double)(f * f * f) - (double)f * Math.sin((double)f * Math.PI)));
    });
    public static final Float2FloatFunction BACK_IN_OUT = ScaleEasings.register("back_in_out", x -> {
        if (x < 0.5f) {
            float f = 2.0f * x;
            return (float)(0.5 * ((double)(f * f * f) - (double)f * Math.sin((double)f * Math.PI)));
        }
        float f = 1.0f - (2.0f * x - 1.0f);
        return (float)(0.5 * (1.0 - ((double)(f * f * f) - (double)f * Math.sin((double)f * Math.PI))) + 0.5);
    });
    public static final Float2FloatFunction BOUNCE_IN = ScaleEasings.register("bounce_in", x -> 1.0f - ((Float)BOUNCE_OUT.apply((Object)Float.valueOf(1.0f - x))).floatValue());
    public static final Float2FloatFunction BOUNCE_OUT = ScaleEasings.register("bounce_out", x -> {
        if (x < 0.36363637f) {
            return 121.0f * x * x / 16.0f;
        }
        if (x < 0.72727275f) {
            return 9.075f * x * x - 9.9f * x + 3.4f;
        }
        if ((double)x < 0.9) {
            return 12.066482f * x * x - 19.635458f * x + 8.898061f;
        }
        return 10.8f * x * x - 20.52f * x + 10.72f;
    });
    public static final Float2FloatFunction BOUNCE_IN_OUT = ScaleEasings.register("bounce_in_out", x -> {
        if (x < 0.5f) {
            return 0.5f * ((Float)BOUNCE_IN.apply((Object)Float.valueOf(x * 2.0f))).floatValue();
        }
        return 0.5f * ((Float)BOUNCE_OUT.apply((Object)Float.valueOf(x * 2.0f - 1.0f))).floatValue() + 0.5f;
    });

    private static Float2FloatFunction register(String path, Float2FloatFunction easing) {
        return ScaleEasings.register(Pehkui.id(path), easing);
    }

    private static Float2FloatFunction register(ResourceLocation id, Float2FloatFunction easing) {
        return ScaleRegistries.register(ScaleRegistries.SCALE_EASINGS, id, easing);
    }

    private ScaleEasings() {
    }
}

