/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.claim.capital;

import java.util.Objects;
import net.mcreator.reignmod.claim.capital.CapitalClaimManager;
import net.mcreator.reignmod.claim.capital.CapitalClaimSavedData;
import net.mcreator.reignmod.claim.capital.ClaimOwner;
import net.mcreator.reignmod.house.HouseSavedData;
import net.mcreator.reignmod.kingdom.KingdomData;
import net.mcreator.reignmod.kingdom.KingdomManager;
import net.mcreator.reignmod.networking.ClientPlayerData;
import net.mcreator.reignmod.networking.ReignNetworking;
import net.mcreator.reignmod.networking.packet.C2S.BlockBreakPermissionQueryC2SPacket;
import net.mcreator.reignmod.procedures.IsClerkProcedure;
import net.mcreator.reignmod.procedures.IsKingProcedure;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ArmorStandItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ChorusFruitItem;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.HangingEntityItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="reign_mod")
public class CapitalClaimProtectionHandler {
    private static boolean isWithinCapital(int localX, int localZ) {
        return localX >= 0 && localX < 511 && localZ >= 0 && localZ < 511;
    }

    public static boolean isWithinCapitalGlobal(int globalX, int globalZ) {
        return CapitalClaimProtectionHandler.isWithinCapital(CapitalClaimManager.toLocalX(globalX), CapitalClaimManager.toLocalZ(globalZ));
    }

    public static boolean isKingOrHand(ServerPlayer sp) {
        return Objects.equals(sp.m_20149_(), KingdomManager.getCourtier(KingdomData.CourtPosition.HAND_OF_THE_KING)) || IsKingProcedure.execute((LevelAccessor)CapitalClaimSavedData.getInstance().getServerLevelInstance(), (Entity)sp);
    }

    public static boolean isMarshal(ServerPlayer sp) {
        return Objects.equals(sp.m_20149_(), KingdomManager.getCourtier(KingdomData.CourtPosition.MARSHAL));
    }

    public static boolean isArchitect(ServerPlayer sp) {
        return Objects.equals(sp.m_20149_(), KingdomManager.getCourtier(KingdomData.CourtPosition.ARCHITECT));
    }

    public static boolean isBuilder(ServerPlayer sp) {
        return KingdomManager.isPlayerBuilder(sp.m_20149_());
    }

    public static boolean hasPermission(ServerPlayer player, BlockPos pos) {
        int localZ;
        if (!CapitalClaimSavedData.getInstance().isCapitalClaimsEnabled() || player.f_8941_.m_9295_()) {
            return true;
        }
        int localX = CapitalClaimManager.toLocalX(pos.m_123341_());
        if (!CapitalClaimProtectionHandler.isWithinCapital(localX, localZ = CapitalClaimManager.toLocalZ(pos.m_123343_()))) {
            return true;
        }
        if (CapitalClaimProtectionHandler.isKingOrHand(player) || IsClerkProcedure.execute((LevelAccessor)HouseSavedData.getServerInstance(), (Entity)player)) {
            return true;
        }
        ClaimOwner owner = CapitalClaimSavedData.getInstance().getOwnerAt(localX, localZ);
        if (owner == null && (CapitalClaimProtectionHandler.isArchitect(player) || CapitalClaimProtectionHandler.isBuilder(player))) {
            return true;
        }
        return owner != null && owner.hasAccess(player.m_20148_());
    }

    private static boolean isOverworld(Level level) {
        return level.m_46472_().equals((Object)Level.f_46428_);
    }

    private static boolean isPlacementItem(Item item) {
        return item instanceof BlockItem || item instanceof HangingEntityItem || item instanceof ArmorStandItem || item instanceof BucketItem || item instanceof BoatItem;
    }

    private static boolean isUsableItem(Item item) {
        return item instanceof EnderpearlItem || item instanceof ChorusFruitItem;
    }

    private static void cancel(Event event) {
        PlayerInteractEvent.RightClickBlock rc;
        if (event.isCancelable()) {
            event.setCanceled(true);
        }
        if (event instanceof PlayerInteractEvent.RightClickBlock) {
            rc = (PlayerInteractEvent.RightClickBlock)event;
            rc.setUseItem(Event.Result.DENY);
            rc.setUseBlock(Event.Result.DENY);
            rc.setCancellationResult(InteractionResult.FAIL);
        }
        if (event instanceof PlayerInteractEvent.RightClickItem) {
            rc = (PlayerInteractEvent.RightClickItem)event;
            rc.setCancellationResult(InteractionResult.FAIL);
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (!(player2 instanceof ServerPlayer) || !CapitalClaimProtectionHandler.isOverworld((player = (ServerPlayer)player2).m_9236_())) {
            return;
        }
        BlockPos pos = event.getPosition().orElse(null);
        if (pos != null && !CapitalClaimProtectionHandler.hasPermission(player, pos)) {
            CapitalClaimProtectionHandler.cancel((Event)event);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        ServerPlayer player;
        Player player2 = event.getPlayer();
        if (player2 instanceof ServerPlayer && CapitalClaimProtectionHandler.isOverworld((player = (ServerPlayer)player2).m_9236_()) && !CapitalClaimProtectionHandler.hasPermission(player, event.getPos())) {
            CapitalClaimProtectionHandler.cancel((Event)event);
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        ServerPlayer player;
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer && CapitalClaimProtectionHandler.isOverworld((player = (ServerPlayer)entity).m_9236_()) && !CapitalClaimProtectionHandler.hasPermission(player, event.getPos())) {
            CapitalClaimProtectionHandler.cancel((Event)event);
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            Entity target = event.getTarget();
            if ((target instanceof HangingEntity || target instanceof ArmorStand || target instanceof Boat) && !CapitalClaimProtectionHandler.hasPermission(player2, target.m_20183_())) {
                CapitalClaimProtectionHandler.cancel((Event)event);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        BlockPos pos;
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && CapitalClaimProtectionHandler.isOverworld((player = (ServerPlayer)player2).m_9236_()) && (!event.getItemStack().m_41614_() && CapitalClaimProtectionHandler.isPlacementItem(event.getItemStack().m_41720_()) || CapitalClaimProtectionHandler.isUsableItem(event.getItemStack().m_41720_())) && CapitalClaimProtectionHandler.isWithinCapitalGlobal((pos = event.getPos()).m_123341_(), pos.m_123343_()) && (CapitalClaimProtectionHandler.isUsableItem(event.getItemStack().m_41720_()) || CapitalClaimProtectionHandler.isPlacementItem(event.getItemStack().m_41720_()) && !CapitalClaimProtectionHandler.hasPermission(player, pos))) {
            CapitalClaimProtectionHandler.cancel((Event)event);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && CapitalClaimProtectionHandler.isOverworld((player = (ServerPlayer)player2).m_9236_()) && (CapitalClaimProtectionHandler.isPlacementItem(event.getItemStack().m_41720_()) || CapitalClaimProtectionHandler.isUsableItem(event.getItemStack().m_41720_())) && CapitalClaimProtectionHandler.isWithinCapitalGlobal((pos = event.getPos().m_121945_(Objects.requireNonNull(event.getFace()))).m_123341_(), pos.m_123343_()) && (CapitalClaimProtectionHandler.isUsableItem(event.getItemStack().m_41720_()) || CapitalClaimProtectionHandler.isPlacementItem(event.getItemStack().m_41720_()) && !CapitalClaimProtectionHandler.hasPermission(player, pos))) {
            CapitalClaimProtectionHandler.cancel((Event)event);
        }
    }

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        BlockPos pos;
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && CapitalClaimProtectionHandler.isOverworld((player = (ServerPlayer)player2).m_9236_()) && (CapitalClaimProtectionHandler.isPlacementItem(event.getItemStack().m_41720_()) || CapitalClaimProtectionHandler.isUsableItem(event.getItemStack().m_41720_())) && CapitalClaimProtectionHandler.isWithinCapitalGlobal((pos = event.getPos()).m_123341_(), pos.m_123343_()) && (CapitalClaimProtectionHandler.isUsableItem(event.getItemStack().m_41720_()) || CapitalClaimProtectionHandler.isPlacementItem(event.getItemStack().m_41720_()) && !CapitalClaimProtectionHandler.hasPermission(player, pos))) {
            CapitalClaimProtectionHandler.cancel((Event)event);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientBreakSpeed(PlayerEvent.BreakSpeed event) {
        LocalPlayer player;
        Player player2 = event.getEntity();
        if (!(player2 instanceof LocalPlayer) || !CapitalClaimProtectionHandler.isOverworld((player = (LocalPlayer)player2).m_9236_())) {
            return;
        }
        BlockPos pos = event.getPosition().orElse(null);
        if (!ClientPlayerData.isLastKnownBlock(pos)) {
            ReignNetworking.sendToServer(new BlockBreakPermissionQueryC2SPacket(pos));
        }
        if (!ClientPlayerData.isLastKnownBlockAvailable()) {
            CapitalClaimProtectionHandler.cancel((Event)event);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientBlockBreak(BlockEvent.BreakEvent event) {
        LocalPlayer player;
        Player player2 = event.getPlayer();
        if (!(player2 instanceof LocalPlayer) || !CapitalClaimProtectionHandler.isOverworld((player = (LocalPlayer)player2).m_9236_())) {
            return;
        }
        BlockPos pos = event.getPos();
        if (!ClientPlayerData.isLastKnownBlock(pos)) {
            ReignNetworking.sendToServer(new BlockBreakPermissionQueryC2SPacket(pos));
        }
        if (!ClientPlayerData.isLastKnownBlockAvailable()) {
            CapitalClaimProtectionHandler.cancel((Event)event);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientRightClickItem(PlayerInteractEvent.RightClickItem event) {
        LocalPlayer lp;
        Player player = event.getEntity();
        if (player instanceof LocalPlayer && CapitalClaimProtectionHandler.isOverworld((lp = (LocalPlayer)player).m_9236_()) && (!event.getItemStack().m_41614_() && CapitalClaimProtectionHandler.isPlacementItem(event.getItemStack().m_41720_()) || CapitalClaimProtectionHandler.isUsableItem(event.getItemStack().m_41720_()))) {
            BlockPos pos = event.getPos();
            if (CapitalClaimProtectionHandler.isUsableItem(event.getItemStack().m_41720_()) && CapitalClaimProtectionHandler.isWithinCapitalGlobal(pos.m_123341_(), pos.m_123343_())) {
                CapitalClaimProtectionHandler.cancel((Event)event);
            }
            if (!ClientPlayerData.isLastKnownBlock(pos)) {
                ReignNetworking.sendToServer(new BlockBreakPermissionQueryC2SPacket(pos));
            }
            if (!ClientPlayerData.isLastKnownBlockAvailable()) {
                CapitalClaimProtectionHandler.cancel((Event)event);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        LocalPlayer lp;
        Player player = event.getEntity();
        if (player instanceof LocalPlayer && CapitalClaimProtectionHandler.isOverworld((lp = (LocalPlayer)player).m_9236_()) && (CapitalClaimProtectionHandler.isPlacementItem(event.getItemStack().m_41720_()) || CapitalClaimProtectionHandler.isUsableItem(event.getItemStack().m_41720_())) && CapitalClaimProtectionHandler.isWithinCapitalGlobal((pos = event.getPos().m_121945_(Objects.requireNonNull(event.getFace()))).m_123341_(), pos.m_123343_())) {
            if (CapitalClaimProtectionHandler.isUsableItem(event.getItemStack().m_41720_())) {
                CapitalClaimProtectionHandler.cancel((Event)event);
            }
            if (!ClientPlayerData.isLastKnownBlock(pos)) {
                ReignNetworking.sendToServer(new BlockBreakPermissionQueryC2SPacket(pos));
            }
            if (!ClientPlayerData.isLastKnownBlockAvailable()) {
                CapitalClaimProtectionHandler.cancel((Event)event);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        BlockPos pos;
        LocalPlayer lp;
        Player player = event.getEntity();
        if (player instanceof LocalPlayer && CapitalClaimProtectionHandler.isOverworld((lp = (LocalPlayer)player).m_9236_()) && (CapitalClaimProtectionHandler.isPlacementItem(event.getItemStack().m_41720_()) || CapitalClaimProtectionHandler.isUsableItem(event.getItemStack().m_41720_())) && CapitalClaimProtectionHandler.isWithinCapitalGlobal((pos = event.getPos()).m_123341_(), pos.m_123343_())) {
            if (CapitalClaimProtectionHandler.isUsableItem(event.getItemStack().m_41720_())) {
                CapitalClaimProtectionHandler.cancel((Event)event);
            }
            if (!ClientPlayerData.isLastKnownBlock(pos)) {
                ReignNetworking.sendToServer(new BlockBreakPermissionQueryC2SPacket(pos));
            }
            if (!ClientPlayerData.isLastKnownBlockAvailable()) {
                CapitalClaimProtectionHandler.cancel((Event)event);
            }
        }
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register(CapitalClaimProtectionHandler.class);
    }
}

