/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.claim.chunk;

import java.util.Optional;
import java.util.UUID;
import net.mcreator.reignmod.claim.capital.CapitalClaimSavedData;
import net.mcreator.reignmod.claim.chunk.ChunkClaimSavedData;
import net.mcreator.reignmod.claim.chunk.ClaimData;
import net.mcreator.reignmod.claim.chunk.ClaimType;
import net.mcreator.reignmod.house.Domain;
import net.mcreator.reignmod.house.House;
import net.mcreator.reignmod.house.HouseManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import xaero.pac.common.server.player.config.PlayerConfig;

public class ChunkClaimManager {
    public static boolean isAreaFree(ChunkPos center, ClaimType type) {
        int radius = type == ClaimType.CAPITAL ? 17 : 10;
        ChunkClaimSavedData storage = ChunkClaimSavedData.getInstance();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                ChunkPos cp = new ChunkPos(center.f_45578_ + dx, center.f_45579_ + dz);
                if (!storage.isClaimed(cp)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean createClaim(ServerPlayer sv, ClaimType claimType, int centerX, int centerY, int centerZ) {
        String claimId;
        House foundHouse;
        Domain foundDomain;
        if (claimType == ClaimType.CAPITAL) {
            return false;
        }
        ChunkPos center = new ChunkPos(new BlockPos(centerX, centerY, centerZ));
        if (!ChunkClaimManager.isAreaFree(center, claimType)) {
            sv.m_5661_((Component)Component.m_237115_((String)"chunkclaim.add.fail.occupied"), true);
            return false;
        }
        if (claimType == ClaimType.DOMAIN) {
            foundDomain = HouseManager.getDomainByKnightUUID(sv.m_20149_());
            foundHouse = HouseManager.getHouseByLordUUID(foundDomain.getLordUUID());
            claimId = foundDomain.getClaimId();
        } else {
            foundHouse = HouseManager.getHouseByLordUUID(sv.m_20149_());
            foundDomain = foundHouse.getDomains().get(sv.m_20149_());
            claimId = foundHouse.getClaimId();
        }
        String claimName = foundHouse.getHouseTitle();
        String ownerName = foundHouse.getHouseTitleWithColor() + ": " + foundDomain.getDomainTitle().getString();
        String color = foundHouse.getHouseColor();
        if (claimId != null) {
            sv.m_5661_((Component)Component.m_237115_((String)"chunkclaim.add.fail.already_own"), true);
            return false;
        }
        claimId = UUID.randomUUID().toString();
        ClaimData data = new ClaimData(claimId, claimName, sv.m_20149_(), ownerName, color, claimType, center.f_45578_, center.f_45579_);
        int radius = 10;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                long chunkId = ChunkPos.m_45589_((int)(center.f_45578_ + dx), (int)(center.f_45579_ + dz));
                data.addChunk(chunkId);
                if (dx != -radius && dx != radius && dz != -radius && dz != radius) continue;
                data.addOuterChunk(chunkId);
            }
        }
        ChunkClaimSavedData.getInstance().addClaim(data);
        if (claimType == ClaimType.DOMAIN) {
            Domain domain = HouseManager.getDomainByKnightUUID(sv.m_20149_());
            domain.setClaimId(claimId);
            domain.setDomainFoundationCoordinates(new int[]{centerX, centerY, centerZ});
        } else {
            HouseManager.getHouseByLordUUID(sv.m_20149_()).setClaimId(claimId);
        }
        sv.m_5661_((Component)Component.m_237115_((String)"chunkclaim.add.success"), true);
        return true;
    }

    public static boolean createCapitalClaim(int centerX, int centerY, int centerZ) {
        ChunkPos center = new ChunkPos(new BlockPos(centerX, centerY, centerZ));
        if (!ChunkClaimManager.isAreaFree(center, ClaimType.CAPITAL)) {
            return false;
        }
        String claimId = CapitalClaimSavedData.getChunkClaimId();
        String ownerName = Component.m_237115_((String)"chunkclaim.capital.name").getString();
        if (claimId != null) {
            return false;
        }
        claimId = UUID.randomUUID().toString();
        String ownerId = ModList.get().isLoaded("openpartiesandclaims") ? PlayerConfig.SERVER_CLAIM_UUID.toString() : claimId;
        ClaimData data = new ClaimData(claimId, ownerName, ownerId, ownerName, "white", ClaimType.CAPITAL, center.f_45578_, center.f_45579_);
        int radius = 17;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                data.addChunk(ChunkPos.m_45589_((int)(center.f_45578_ + dx), (int)(center.f_45579_ + dz)));
            }
        }
        ChunkClaimSavedData.getInstance().addClaim(data);
        CapitalClaimSavedData.setChunkClaimId(claimId);
        return true;
    }

    public static void removeClaim(ServerPlayer sv, String claimId) {
        if (ChunkClaimSavedData.getInstance().getClaim(claimId).isPresent()) {
            ChunkClaimManager.removeClaim(claimId);
            sv.m_5661_((Component)Component.m_237115_((String)"chunkclaim.remove.success"), true);
        }
        sv.m_5661_((Component)Component.m_237115_((String)"chunkclaim.remove.not_found"), true);
    }

    public static void removeClaim(ServerPlayer sp) {
        Optional<String> claim = ChunkClaimManager.getClaimIdByChunk(new ChunkPos(sp.m_20097_()));
        if (claim.isPresent()) {
            ChunkClaimManager.removeClaim(claim.get());
            sp.m_5661_((Component)Component.m_237115_((String)"chunkclaim.remove.success"), false);
        }
        sp.m_5661_((Component)Component.m_237115_((String)"chunkclaim.remove.not_found"), false);
    }

    public static void removeClaim(String claimId) {
        if (ChunkClaimSavedData.getInstance().getClaim(claimId).isPresent()) {
            String ownerId = ChunkClaimSavedData.getInstance().getClaim(claimId).get().getOwnerId();
            ClaimType type = ChunkClaimSavedData.getInstance().getClaim(claimId).get().getClaimType();
            if (type == ClaimType.DOMAIN) {
                HouseManager.getDomainByKnightUUID(ownerId).setClaimId(null);
            } else if (type == ClaimType.HOUSE) {
                HouseManager.getHouseByLordUUID(ownerId).setClaimId(null);
            } else {
                CapitalClaimSavedData.setChunkClaimId(null);
            }
            ChunkClaimSavedData.getInstance().removeClaim(claimId);
        }
    }

    public static Optional<String> getChunkOwner(int chunkX, int chunkZ) {
        return ChunkClaimSavedData.getInstance().getClaimByChunk(chunkX, chunkZ).map(ClaimData::getOwnerId);
    }

    public static Optional<String> getChunkOwnerName(ChunkPos chunkPos) {
        return ChunkClaimSavedData.getInstance().getClaimByChunk(chunkPos.f_45578_, chunkPos.f_45579_).map(ClaimData::getOwnerName);
    }

    public static boolean isOwnerOfChunk(String ownerId, int chunkX, int chunkZ) {
        return ChunkClaimManager.getChunkOwner(chunkX, chunkZ).filter(o -> o.equals(ownerId)).isPresent();
    }

    public static Optional<String> getClaimIdByChunk(int chunkX, int chunkZ) {
        return ChunkClaimSavedData.getInstance().getClaimByChunk(chunkX, chunkZ).map(ClaimData::getClaimId);
    }

    public static Optional<String> getClaimIdByChunk(ChunkPos cp) {
        return ChunkClaimManager.getClaimIdByChunk(cp.f_45578_, cp.f_45579_);
    }

    public static boolean hasPermission(ServerPlayer player, BlockPos pos) {
        return ChunkClaimManager.hasPermission(player, new ChunkPos(pos));
    }

    public static boolean hasPermission(ServerPlayer player, ChunkPos pos) {
        if (!player.m_9236_().m_46472_().equals((Object)Level.f_46428_)) {
            return true;
        }
        if (player.f_8941_.m_9295_()) {
            return true;
        }
        Optional<ClaimData> claimOpt = ChunkClaimSavedData.getInstance().getClaimByChunk(pos.f_45578_, pos.f_45579_);
        if (claimOpt.isEmpty()) {
            return true;
        }
        ClaimData claimData = claimOpt.get();
        if (claimData.getClaimType() == ClaimType.HOUSE) {
            House chunkHouse = HouseManager.getHouseByLordUUID(claimData.getOwnerId());
            if (!chunkHouse.isNull()) {
                return chunkHouse.getDomains().containsKey(player.m_20149_()) || chunkHouse.getDomains().get(chunkHouse.getLordUUID()).getPlayers().contains(player.m_20149_()) || chunkHouse.isIndirectVassalsBeTrusted() && chunkHouse.getPlayers().contains(player.m_20149_());
            }
        } else if (claimData.getClaimType() == ClaimType.DOMAIN) {
            Domain domain = HouseManager.getDomainByKnightUUID(claimData.getOwnerId());
            House chunkHouse = HouseManager.getHouseByLordUUID(domain.getLordUUID());
            if (!domain.isNull()) {
                if (!chunkHouse.isNull() && chunkHouse.isIndirectVassalsBeTrusted() && chunkHouse.getPlayers().contains(player.m_20149_())) {
                    return true;
                }
                return domain.getPlayers().contains(player.m_20149_()) || domain.getLordUUID().equals(player.m_20149_());
            }
        } else {
            return true;
        }
        return false;
    }
}

