/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.claim.chunk;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.mcreator.reignmod.claim.chunk.ClaimType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.common.util.INBTSerializable;

public class ClaimData
implements INBTSerializable<CompoundTag> {
    private String claimId;
    private String claimName;
    private String ownerId;
    private String ownerName;
    private String color;
    private ClaimType claimType;
    private int centerChunkX;
    private int centerChunkZ;
    private final Set<Long> claimedChunks = new HashSet<Long>();
    private final Set<Long> outerChunks = new HashSet<Long>();

    public ClaimData() {
    }

    public ClaimData(String claimId, String claimName, String ownerId, String ownerName, String color, ClaimType claimType, int centerChunkX, int centerChunkZ) {
        this.claimId = claimId;
        this.claimName = claimName;
        this.ownerId = ownerId;
        this.ownerName = ownerName;
        this.color = color;
        this.claimType = claimType;
        this.centerChunkX = centerChunkX;
        this.centerChunkZ = centerChunkZ;
    }

    public String getClaimId() {
        return this.claimId;
    }

    public void setClaimId(String claimId) {
        this.claimId = claimId;
    }

    public String getClaimName() {
        return this.claimName;
    }

    public void setClaimName(String claimName) {
        this.claimName = claimName;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public ClaimType getClaimType() {
        return this.claimType;
    }

    public void setClaimType(ClaimType claimType) {
        this.claimType = claimType;
    }

    public int getCenterChunkX() {
        return this.centerChunkX;
    }

    public void setCenterChunkX(int centerChunkX) {
        this.centerChunkX = centerChunkX;
    }

    public int getCenterChunkZ() {
        return this.centerChunkZ;
    }

    public void setCenterChunkZ(int centerChunkZ) {
        this.centerChunkZ = centerChunkZ;
    }

    public boolean addChunk(long chunkId) {
        return this.claimedChunks.add(chunkId);
    }

    public boolean removeChunk(long chunkId) {
        boolean removed = this.claimedChunks.remove(chunkId);
        if (removed) {
            int[][] DIRS = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}};
            ChunkPos cp = new ChunkPos(chunkId);
            for (int[] d : DIRS) {
                int nx = cp.f_45578_ + d[0];
                int nz = cp.f_45579_ + d[1];
                long neighborId = ChunkPos.m_45589_((int)nx, (int)nz);
                if (!this.containsChunk(neighborId)) continue;
                this.outerChunks.add(neighborId);
            }
        }
        return removed;
    }

    public boolean containsChunk(long chunkId) {
        return this.claimedChunks.contains(chunkId);
    }

    public boolean addOuterChunk(long chunkId) {
        return this.outerChunks.add(chunkId);
    }

    public boolean removeOuterChunk(long chunkId) {
        return this.outerChunks.remove(chunkId);
    }

    public boolean containsOuterChunk(long chunkId) {
        return this.outerChunks.contains(chunkId);
    }

    public Set<Long> getClaimedChunks() {
        return Collections.unmodifiableSet(this.claimedChunks);
    }

    public Set<Long> getOuterChunks() {
        return Collections.unmodifiableSet(this.outerChunks);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("claim_id", this.claimId);
        tag.m_128359_("claim_name", this.claimName);
        tag.m_128359_("owner_id", this.ownerId);
        tag.m_128359_("owner_name", this.ownerName);
        tag.m_128359_("color", this.color);
        tag.m_128359_("claim_type", this.claimType.name());
        tag.m_128405_("center_chunk_x", this.centerChunkX);
        tag.m_128405_("center_chunk_z", this.centerChunkZ);
        ListTag list = new ListTag();
        for (Long chunkId : this.claimedChunks) {
            list.add((Object)StringTag.m_129297_((String)chunkId.toString()));
        }
        tag.m_128365_("claimed_chunks", (Tag)list);
        list = new ListTag();
        for (Long chunkId : this.outerChunks) {
            list.add((Object)StringTag.m_129297_((String)chunkId.toString()));
        }
        tag.m_128365_("outer_chunks", (Tag)list);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.claimId = tag.m_128461_("claim_id");
        this.claimName = tag.m_128461_("claim_name");
        this.ownerId = tag.m_128461_("owner_id");
        this.ownerName = tag.m_128461_("owner_name");
        this.color = tag.m_128461_("color");
        this.claimType = ClaimType.valueOf(tag.m_128461_("claim_type"));
        this.centerChunkX = tag.m_128451_("center_chunk_x");
        this.centerChunkZ = tag.m_128451_("center_chunk_z");
        this.claimedChunks.clear();
        ListTag list = tag.m_128437_("claimed_chunks", 8);
        list.forEach(nbt -> {
            long cid = Long.parseLong(nbt.m_7916_());
            this.claimedChunks.add(cid);
        });
        this.outerChunks.clear();
        list = tag.m_128437_("outer_chunks", 8);
        list.forEach(nbt -> {
            long cid = Long.parseLong(nbt.m_7916_());
            this.outerChunks.add(cid);
        });
    }
}

