/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.claim.chunk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.mcreator.reignmod.claim.chunk.ChunkClaimManager;
import net.mcreator.reignmod.claim.chunk.ChunkClaimSavedData;
import net.mcreator.reignmod.claim.chunk.ClaimData;
import net.mcreator.reignmod.claim.chunk.ClaimType;
import net.mcreator.reignmod.house.House;
import net.mcreator.reignmod.house.HouseManager;
import net.mcreator.reignmod.init.ReignModModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Expansion {
    private static final double EXPANSION_CHANCE_NORMAL = 0.1;
    private static final double EXPANSION_CHANCE_RIVER = 0.001;
    private static final double MIN_COST_PER_CHUNK = 0.1;
    private static final double MAX_COST_PER_CHUNK = 0.5;
    private static final double DEFENCE_COST_PER_CHUNK_MULTIPLIER = 0.7;
    private static final int MAX_HOUSE_CHUNKS = 16384;
    private static final int MAX_DOMAIN_CHUNKS = 8192;
    private static final int MIN_STANDARD_CHUNKS = 441;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int[][] CARDINAL_DIRS = new int[][]{{-1, 0}, {0, 1}, {1, 0}, {0, -1}};
    private static final double[] BASE_DIR_MULTIPLIERS = new double[]{3.0, 0.5, 0.0, 0.5};

    public static void expandAll() {
        ChunkClaimSavedData saved = ChunkClaimSavedData.getInstance();
        for (String claimID : saved.getClaims().keySet()) {
            if (saved.getClaim(claimID).isEmpty() || saved.getClaim(claimID).get().getClaimType() == ClaimType.CAPITAL) continue;
            LOGGER.debug("Expanding territory {}", (Object)saved.getClaim(claimID).get().getOwnerName());
            Expansion.expandTerritory(claimID);
            LOGGER.debug("Expansion complete for territory {}", (Object)saved.getClaim(claimID).get().getOwnerName());
            saved.m_77762_();
        }
    }

    private static void expandTerritory(String claimID) {
        Optional<ClaimData> territory = ChunkClaimSavedData.getInstance().getClaim(claimID);
        if (territory.isEmpty() || territory.get().getClaimType() == ClaimType.CAPITAL) {
            return;
        }
        ServerLevel level = ChunkClaimSavedData.getServerInstance();
        BlockEntity strat = Expansion.getStrategyData(level, territory.get());
        if (strat == null) {
            return;
        }
        Set<Long> candidates = Expansion.collectExpansionCandidates(level, territory.get());
        LOGGER.debug("Expansion candidates: {}", (Object)candidates.size());
        if (candidates.isEmpty()) {
            return;
        }
        double cost = Expansion.calculateCostPerChunk(territory.get());
        LOGGER.debug("Expansion cost per chunk: {}", (Object)cost);
        double attackCoins = strat.getPersistentData().m_128459_("attack_coins");
        LOGGER.debug("Attack coins: {}", (Object)attackCoins);
        double remainingCoins = Expansion.applyExpansion(level, territory.get(), candidates, cost, attackCoins);
        LOGGER.debug("Remaining attack coins: {}", (Object)remainingCoins);
        strat.getPersistentData().m_128347_("attack_coins", remainingCoins);
        strat.m_6596_();
    }

    private static Set<Long> collectExpansionCandidates(ServerLevel level, ClaimData territory) {
        LinkedHashSet<Long> newCandidates = new LinkedHashSet<Long>();
        HashSet<Long> outer = new HashSet<Long>(territory.getOuterChunks());
        LOGGER.debug("OuterChunks amount: {}", (Object)outer.size());
        ArrayList<Double> cardinal_dirs_multipliers = new ArrayList<Double>();
        BlockEntity strategy_block_entity = Expansion.getStrategyData(level, territory);
        assert (strategy_block_entity != null);
        int direction = (int)strategy_block_entity.getPersistentData().m_128459_("direction");
        if (direction == -1) {
            cardinal_dirs_multipliers.addAll(Arrays.asList(1.0, 1.0, 1.0, 1.0));
        } else {
            for (int i = 0; i < 4; ++i) {
                cardinal_dirs_multipliers.add(BASE_DIR_MULTIPLIERS[(direction + i) % 4]);
            }
            LOGGER.debug("Cardinal dirs multipliers: {}", cardinal_dirs_multipliers);
        }
        Iterator iterator = outer.iterator();
        while (iterator.hasNext()) {
            long chunkId = (Long)iterator.next();
            ChunkPos cp = new ChunkPos(chunkId);
            boolean allNeighborsOwned = true;
            for (int i = 0; i < 4; ++i) {
                int[] dir = CARDINAL_DIRS[i];
                double multiplier = (Double)cardinal_dirs_multipliers.get(i);
                int dx = dir[0];
                int dz = dir[1];
                ChunkPos neighbor = new ChunkPos(cp.f_45578_ + dx, cp.f_45579_ + dz);
                if (territory.containsChunk(neighbor.m_45588_())) continue;
                allNeighborsOwned = false;
                if (!Expansion.isExpandableNeighbor(level, neighbor, multiplier)) continue;
                newCandidates.add(neighbor.m_45588_());
            }
            if (!allNeighborsOwned) continue;
            territory.removeOuterChunk(chunkId);
        }
        return newCandidates;
    }

    private static boolean isExpandableNeighbor(ServerLevel level, ChunkPos pos, double chanceModifier) {
        BlockPos center = new BlockPos(pos.m_45604_() + 8, 0, pos.m_45605_() + 8);
        Holder holder = level.m_204166_(center);
        if (holder.m_203656_(BiomeTags.f_207603_) || holder.m_203656_(BiomeTags.f_207602_)) {
            return false;
        }
        ClaimType claimId = ChunkClaimManager.getClaimIdByChunk(pos).flatMap(id -> ChunkClaimSavedData.getInstance().getClaim((String)id)).map(ClaimData::getClaimType).orElse(null);
        if (claimId == ClaimType.CAPITAL) {
            return false;
        }
        double chance = holder.m_203656_(BiomeTags.f_207605_) ? 0.001 : 0.1;
        return Math.random() < chance * chanceModifier;
    }

    private static double calculateCostPerChunk(ClaimData territory) {
        int currentSize = territory.getClaimedChunks().size();
        int maxSize = territory.getClaimType() == ClaimType.HOUSE ? 16384 : 8192;
        double ratio = (double)currentSize / (double)maxSize;
        double minRatio = 441.0 / (double)maxSize;
        double factor = (ratio - minRatio) / (1.0 - minRatio);
        return 0.1 + factor * 0.4;
    }

    private static BlockEntity getStrategyData(ServerLevel level, ClaimData territory) {
        LOGGER.debug("Territory type: {}", (Object)(territory.getClaimType() == ClaimType.HOUSE ? "HOUSE" : "DOMAIN"));
        int[] coords = HouseManager.getDomainByKnightUUID(territory.getOwnerId()).getDomainStrategyBlockCoordinates();
        LOGGER.debug("Strategy block coordinates: {}", (Object)Arrays.toString(coords));
        BlockPos pos = new BlockPos(coords[0], coords[1], coords[2]);
        BlockState bs = level.m_8055_(pos);
        if (bs.m_60734_() != ReignModModBlocks.STRATEGY_BLOCK.get()) {
            return null;
        }
        BlockEntity be = level.m_7702_(pos);
        LOGGER.debug("Strategy block entity: {}", (Object)(be != null ? "EXISTS" : "DOES NOT EXIST"));
        return be;
    }

    private static double applyExpansion(ServerLevel level, ClaimData attacker, Set<Long> candidates, double cost, double attackCoins) {
        for (long cid : candidates) {
            ChunkPos cp = new ChunkPos(cid);
            if (attackCoins < cost) break;
            Optional<ClaimData> defenderOpt = ChunkClaimSavedData.getInstance().getClaimByChunk(cid);
            if (defenderOpt.isEmpty()) {
                attackCoins = Expansion.claimChunk(attacker, cid, cost, attackCoins);
                continue;
            }
            ClaimData defender = defenderOpt.get();
            if (Math.abs(defender.getCenterChunkX() - cp.f_45578_) <= 10 && Math.abs(defender.getCenterChunkZ() - cp.f_45579_) <= 10) continue;
            House attackerHouse = HouseManager.getHouseBySuzerainUUID(attacker.getOwnerId());
            House defenderHouse = HouseManager.getHouseBySuzerainUUID(defender.getOwnerId());
            if (attackerHouse != null && attackerHouse.equals(defenderHouse)) continue;
            attackCoins = Expansion.fightOverChunk(level, attacker, defender, cid, cost, attackCoins);
        }
        return attackCoins;
    }

    private static double claimChunk(ClaimData territory, long cid, double cost, double attackCoins) {
        ChunkClaimSavedData.getInstance().addChunk(territory.getClaimId(), cid);
        return attackCoins - cost;
    }

    private static double fightOverChunk(ServerLevel level, ClaimData attacker, ClaimData defender, long cid, double cost, double attackCoins) {
        double defCost = cost * 0.7;
        BlockEntity defStrat = Expansion.getStrategyData(level, defender);
        ChunkPos cp = new ChunkPos(cid);
        double defCoins = defStrat == null ? 0.0 : defStrat.getPersistentData().m_128459_("defence_coins");
        boolean surrounded = true;
        for (int[] dir : CARDINAL_DIRS) {
            int dx = dir[0];
            int dz = dir[1];
            ChunkPos neighbor = new ChunkPos(cp.f_45578_ + dx, cp.f_45579_ + dz);
            if (attacker.containsChunk(neighbor.m_45588_())) continue;
            surrounded = false;
        }
        if (surrounded || defStrat == null || defCoins < defCost) {
            LOGGER.debug("Removing chunk {} from {}", (Object)cid, (Object)defender.getOwnerName());
            ChunkClaimSavedData.getInstance().removeChunk(defender.getClaimId(), cid);
            LOGGER.debug("Adding chunk {} to {}", (Object)cid, (Object)attacker.getOwnerName());
            ChunkClaimSavedData.getInstance().addChunk(attacker.getClaimId(), cid);
        } else {
            LOGGER.debug("Defender {} reflects attack from {}", (Object)defender.getOwnerName(), (Object)attacker.getOwnerName());
            defStrat.getPersistentData().m_128347_("defence_coins", defCoins - defCost);
            defStrat.m_6596_();
        }
        return attackCoins - cost;
    }
}

