/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.kingdom;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.UUID;
import net.mcreator.reignmod.house.House;
import net.mcreator.reignmod.house.HouseSavedData;
import net.mcreator.reignmod.kingdom.KingdomData;
import net.mcreator.reignmod.kingdom.KingdomSavedData;
import net.mcreator.reignmod.procedures.FundUpdateInfoProcedure;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class KingdomManager {
    private static final KingInfluenceCache cache = new KingInfluenceCache();

    private static KingdomData get() {
        return KingdomSavedData.getInstance().getKingdomData();
    }

    public static int getCapitalEra() {
        return KingdomManager.get().getCapitalEra();
    }

    public static void setCapitalEra(int value) {
        KingdomManager.get().setCapitalEra(value);
        KingdomSavedData.getInstance().m_77762_();
    }

    public static int getCapitalDiscontent() {
        return KingdomManager.get().getCapitalDiscontent();
    }

    public static void setCapitalDiscontent(int value) {
        KingdomManager.get().setCapitalDiscontent(value);
        KingdomSavedData.getInstance().m_77762_();
    }

    public static int getSourceDisturbance() {
        return KingdomManager.get().getSourceDisturbance();
    }

    public static void setSourceDisturbance(int value) {
        KingdomManager.get().setSourceDisturbance(value);
        KingdomSavedData.getInstance().m_77762_();
    }

    public static int[] getFundCoordinates() {
        return KingdomManager.get().getFundCoordinates();
    }

    public static void setFundCoordinates(int x, int y, int z) {
        KingdomManager.get().setFundCoordinates(x, y, z);
        KingdomSavedData.getInstance().m_77762_();
    }

    public static int[] getCoffersCoordinates() {
        return KingdomManager.get().getCoffersCoordinates();
    }

    public static void setCoffersCoordinates(int x, int y, int z) {
        KingdomManager.get().setCoffersCoordinates(x, y, z);
        KingdomSavedData.getInstance().m_77762_();
    }

    public static int[] getPrisonCoordinates() {
        return KingdomManager.get().getPrisonCoordinates();
    }

    public static void setPrisonCoordinates(int x, int y, int z) {
        KingdomManager.get().setPrisonCoordinates(x, y, z);
        KingdomSavedData.getInstance().m_77762_();
    }

    public static String getCourtier(KingdomData.CourtPosition pos) {
        return KingdomManager.get().getCourtier(pos);
    }

    public static void assignCourtier(KingdomData.CourtPosition pos, String playerId) {
        KingdomManager.get().assignCourtier(pos, playerId);
        KingdomSavedData.getInstance().m_77762_();
    }

    public static void dismissCourtier(KingdomData.CourtPosition pos) {
        KingdomManager.get().dismissCourtier(pos);
        KingdomSavedData.getInstance().m_77762_();
    }

    public static EnumMap<KingdomData.CourtPosition, String> getAllCourtiers() {
        return KingdomManager.get().getAllCourtiers();
    }

    public static KingdomData.CourtPosition getPlayerPosition(String playerId) {
        return KingdomManager.get().getPlayerPosition(playerId);
    }

    public static boolean isPlayerInCourt(String playerId) {
        return KingdomManager.get().isPlayerInCourt(playerId);
    }

    public static HashSet<String> getBuilders() {
        return KingdomManager.get().getBuilders();
    }

    public static void assignBuilder(String playerId) {
        KingdomManager.get().assignBuilder(playerId);
        KingdomSavedData.getInstance().m_77762_();
    }

    public static void dismissBuilder(String playerId) {
        KingdomManager.get().dismissBuilder(playerId);
        KingdomSavedData.getInstance().m_77762_();
    }

    public static void dismissAllBuilders() {
        KingdomManager.get().dismissAllBuilders();
        KingdomSavedData.getInstance().m_77762_();
    }

    public static boolean isPlayerBuilder(String playerId) {
        return KingdomManager.get().isPlayerBuilder(playerId);
    }

    public static UUID getKingUUID() {
        return KingdomManager.get().getKingUUID();
    }

    public static void setKingUUID(UUID value) {
        KingdomManager.get().setKingUUID(value);
        KingdomSavedData.getInstance().m_77762_();
        KingdomManager.updateFundInfo();
    }

    public static double getKingInfluence() {
        return cache.get();
    }

    private static double calculateKingInfluence() {
        Collection<House> houses = HouseSavedData.getInstance().getHouseData().getHouses().values();
        if (houses.isEmpty()) {
            return 0.0;
        }
        int forKing = 0;
        int totalInfluence = 0;
        for (House house : houses) {
            int influence = house.getInfluence();
            totalInfluence += influence;
            if (!house.isOathToKingTaken()) continue;
            forKing += influence;
        }
        return totalInfluence == 0 ? 0.0 : (double)forKing / (double)totalInfluence;
    }

    public static void upgradeCapitalEra() {
        KingdomManager.get().upgradeCapitalEra();
        KingdomSavedData.getInstance().m_77762_();
    }

    public static int getCapitalMaintenance() {
        return KingdomManager.get().getCapitalMaintenance();
    }

    public static void feedCapital() {
        KingdomManager.get().feedCapital();
        KingdomSavedData.getInstance().m_77762_();
    }

    public static BlockState getFundBlockState() {
        return KingdomManager.get().getFundBlockState();
    }

    public static BlockState getCoffersBlockState() {
        return KingdomManager.get().getCoffersBlockState();
    }

    public static void updateFundInfo() {
        FundUpdateInfoProcedure.execute((LevelAccessor)HouseSavedData.getServerInstance(), KingdomManager.getFundCoordinates()[0], KingdomManager.getFundCoordinates()[1], KingdomManager.getFundCoordinates()[2]);
    }

    private static class KingInfluenceCache {
        private double cachedValue;
        private long lastCalculated;
        private static final long CACHE_TTL_MS = 3000L;

        private KingInfluenceCache() {
        }

        public double get() {
            long now = System.currentTimeMillis();
            if (now - this.lastCalculated > 3000L) {
                this.cachedValue = KingdomManager.calculateKingInfluence();
                this.lastCalculated = now;
            }
            return this.cachedValue;
        }
    }
}

