/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.mines;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mcreator.reignmod.mines.MineData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;

public class MineChunkData {
    private final Map<ChunkPos, MineData> mines = new HashMap<ChunkPos, MineData>();
    private final Set<ChunkPos> checkedChunks = new HashSet<ChunkPos>();

    public void addMine(ChunkPos chunkPos, MineData data) {
        this.mines.put(chunkPos, data);
        this.checkedChunks.add(chunkPos);
    }

    public void removeMine(ChunkPos chunkPos) {
        this.mines.remove(chunkPos);
    }

    public Map<ChunkPos, MineData> getMines() {
        return this.mines;
    }

    public Optional<MineData> getMine(ChunkPos chunkPos) {
        return Optional.ofNullable(this.mines.get(chunkPos));
    }

    public boolean isChecked(ChunkPos chunkPos) {
        return this.checkedChunks.contains(chunkPos);
    }

    public void markChecked(ChunkPos chunkPos) {
        this.checkedChunks.add(chunkPos);
    }

    public void setMineBlockPos(ChunkPos chunkPos, BlockPos pos) {
        MineData mine = this.mines.get(chunkPos);
        if (mine != null) {
            mine.setMineBlockPos(pos);
        }
    }

    public Optional<BlockEntity> getMineBlockEntity(ServerLevel level, ChunkPos chunkPos) {
        MineData mine = this.mines.get(chunkPos);
        if (mine == null || mine.getMineBlockPos() == null) {
            return Optional.empty();
        }
        BlockPos pos = mine.getMineBlockPos();
        if (!level.m_46749_(pos)) {
            return Optional.empty();
        }
        BlockEntity be = level.m_7702_(pos);
        return Optional.ofNullable(be);
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        ListTag mineList = new ListTag();
        for (Map.Entry<ChunkPos, MineData> entry : this.mines.entrySet()) {
            CompoundTag mineTag = entry.getValue().save();
            mineList.add((Object)mineTag);
        }
        tag.m_128365_("mines", (Tag)mineList);
        ListTag checkedTag = new ListTag();
        for (ChunkPos pos : this.checkedChunks) {
            CompoundTag c = new CompoundTag();
            c.m_128405_("x", pos.f_45578_);
            c.m_128405_("z", pos.f_45579_);
            checkedTag.add((Object)c);
        }
        tag.m_128365_("checkedChunks", (Tag)checkedTag);
        return tag;
    }

    public void load(CompoundTag tag) {
        this.mines.clear();
        this.checkedChunks.clear();
        ListTag mineList = tag.m_128437_("mines", 10);
        for (Tag raw : mineList) {
            CompoundTag mineTag = (CompoundTag)raw;
            MineData mine = MineData.load(mineTag);
            this.mines.put(mine.getChunkPos(), mine);
        }
        ListTag checkedTag = tag.m_128437_("checkedChunks", 10);
        for (Tag raw : checkedTag) {
            CompoundTag c = (CompoundTag)raw;
            int x = c.m_128451_("x");
            int z = c.m_128451_("z");
            this.checkedChunks.add(new ChunkPos(x, z));
        }
    }
}

