/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.mines;

import java.util.HashMap;
import java.util.Map;
import net.mcreator.reignmod.basics.ReignSavedData;
import net.mcreator.reignmod.mines.MineChunkData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.NotNull;

public class MineSavedData
extends ReignSavedData {
    public static final String ID = "mine_data";
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private final MineChunkData mineData = new MineChunkData();
    private final Map<String, ChunkPos> playerAssignments = new HashMap<String, ChunkPos>();
    private static MineSavedData instance;

    public MineSavedData() {
    }

    public MineSavedData(CompoundTag compoundTag) {
        this.mineData.load(compoundTag);
        ListTag list = compoundTag.m_128437_("playerAssignments", 10);
        for (Tag raw : list) {
            CompoundTag entry = (CompoundTag)raw;
            String uuid = entry.m_128461_("uuid");
            int x = entry.m_128451_("chunkX");
            int z = entry.m_128451_("chunkZ");
            this.playerAssignments.put(uuid, new ChunkPos(x, z));
        }
    }

    public static void initialize(ServerLevel serverLevel) {
        if (instance == null) {
            instance = (MineSavedData)serverLevel.m_8895_().m_164861_(MineSavedData::new, MineSavedData::new, ID);
            MineSavedData.instance.serverLevelInstance = serverLevel;
        }
    }

    public static void resetInstance() {
        instance = null;
    }

    public static MineSavedData getInstance() {
        if (instance == null) {
            throw new IllegalStateException("MineSavedData has not been initialized. Call initialize(ServerLevel) first.");
        }
        return instance;
    }

    public static ServerLevel getServerInstance() {
        return MineSavedData.getInstance().getServerLevelInstance();
    }

    public static RandomSource getRandom() {
        return RANDOM;
    }

    @Override
    protected String getDataKey() {
        return ID;
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128391_(this.mineData.save());
        ListTag list = new ListTag();
        for (Map.Entry<String, ChunkPos> e : this.playerAssignments.entrySet()) {
            CompoundTag entry = new CompoundTag();
            entry.m_128359_("uuid", e.getKey());
            entry.m_128405_("chunkX", e.getValue().f_45578_);
            entry.m_128405_("chunkZ", e.getValue().f_45579_);
            list.add((Object)entry);
        }
        tag.m_128365_("playerAssignments", (Tag)list);
        return tag;
    }

    public MineChunkData getMineData() {
        return this.mineData;
    }

    public Map<String, ChunkPos> getPlayerAssignments() {
        return this.playerAssignments;
    }

    public void clearAssignmentsForChunk(ChunkPos chunkPos) {
        this.playerAssignments.entrySet().removeIf(stringChunkPosEntry -> ((ChunkPos)stringChunkPosEntry.getValue()).equals((Object)chunkPos));
    }
}

