/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.mixins;

import java.util.Objects;
import net.mcreator.reignmod.block.PrivatedoorBlock;
import net.mcreator.reignmod.block.entity.PrivatedoorBlockEntity;
import net.mcreator.reignmod.claim.capital.CapitalClaimProtectionHandler;
import net.mcreator.reignmod.claim.capital.CapitalClaimSavedData;
import net.mcreator.reignmod.house.HouseManager;
import net.mcreator.reignmod.kingdom.KingdomManager;
import net.mcreator.reignmod.networking.ClientPlayerData;
import net.mcreator.reignmod.networking.ReignNetworking;
import net.mcreator.reignmod.networking.packet.C2S.DoorOpenPermissionQueryC2SPacket;
import net.mcreator.reignmod.procedures.IsKingProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DoorBlock.class})
public class DoorLockMixin {
    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void blockDoorAccess(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        PrivatedoorBlockEntity door;
        BlockPos lowerPos;
        BlockEntity entity;
        if (!level.f_46443_ && state.m_60734_() instanceof PrivatedoorBlock && (entity = level.m_7702_(lowerPos = state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER ? pos : pos.m_7495_())) instanceof PrivatedoorBlockEntity && this.reignMod$isDoorLocked(door = (PrivatedoorBlockEntity)entity, player, level, lowerPos)) {
            cir.setReturnValue((Object)InteractionResult.PASS);
        }
        if (level.f_46443_ && state.m_60734_() instanceof PrivatedoorBlock) {
            BlockPos blockPos = lowerPos = state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER ? pos : pos.m_7495_();
            if (ClientPlayerData.isLastKnownDoorEmpty() || !ClientPlayerData.isLastKnownDoor(lowerPos)) {
                ReignNetworking.sendToServer(new DoorOpenPermissionQueryC2SPacket(lowerPos));
            }
            if (!ClientPlayerData.isLastKnownDoorAvailable()) {
                level.m_5594_(null, lowerPos, SoundEvents.f_12055_, SoundSource.BLOCKS, 0.5f, 1.0f);
                player.m_5661_((Component)Component.m_237115_((String)"translation.key.locked"), true);
                cir.setReturnValue((Object)InteractionResult.PASS);
            }
        }
    }

    @Unique
    private boolean reignMod$isDoorLocked(PrivatedoorBlockEntity door, Player player, Level level, BlockPos pos) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            CompoundTag tag = door.getPersistentData();
            if (tag.m_128441_("owner")) {
                String owner = tag.m_128461_("owner");
                String ownerName = tag.m_128461_("owner_name");
                String lockType = tag.m_128461_("lock_type");
                if (!owner.isEmpty() && !this.reign$canOpen(sp, owner, lockType)) {
                    level.m_5594_(null, pos, SoundEvents.f_12055_, SoundSource.BLOCKS, 0.5f, 1.0f);
                    sp.m_5661_((Component)Component.m_237115_((String)"translation.key.locked").m_130946_(" " + ownerName), true);
                    return true;
                }
            }
        }
        return false;
    }

    @Unique
    private boolean reign$canOpen(ServerPlayer sp, String owner, String lockType) {
        return switch (lockType) {
            case "personal" -> sp.m_20149_().equals(owner);
            case "domain" -> {
                if (sp.m_20149_().equals(owner) || Objects.equals(HouseManager.getDomainLordByKnight(owner), sp.m_20149_()) || Objects.equals(HouseManager.getPlayerDomainKnight((Player)sp), owner)) {
                    yield true;
                }
                yield false;
            }
            case "house" -> Objects.equals(HouseManager.getPlayerHouseLord((Player)sp), owner);
            case "prison" -> {
                if (CapitalClaimProtectionHandler.isMarshal(sp) || CapitalClaimProtectionHandler.isKingOrHand(sp)) {
                    yield true;
                }
                yield false;
            }
            case "royal" -> {
                if (KingdomManager.isPlayerInCourt(sp.m_20149_()) || IsKingProcedure.execute((LevelAccessor)CapitalClaimSavedData.getInstance().getServerLevelInstance(), (Entity)sp)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

