/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.networking.packet.C2S;

import java.util.function.Supplier;
import net.mcreator.reignmod.claim.capital.CapitalClaimProtectionHandler;
import net.mcreator.reignmod.networking.ReignNetworking;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class BlockBreakPermissionQueryC2SPacket {
    private final BlockPos blockPos;

    public BlockBreakPermissionQueryC2SPacket(BlockPos blockPos) {
        this.blockPos = new BlockPos((Vec3i)blockPos);
    }

    public BlockBreakPermissionQueryC2SPacket(FriendlyByteBuf buf) {
        this.blockPos = new BlockPos((Vec3i)buf.m_130135_());
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.blockPos);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            if (sender != null) {
                boolean canBreak = CapitalClaimProtectionHandler.hasPermission(sender, this.blockPos);
                ReignNetworking.sendBlockBreakPermissionSync(sender, this.blockPos, canBreak);
            }
        });
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }
}

