/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.networking.packet.C2S;

import java.util.Objects;
import java.util.function.Supplier;
import net.mcreator.reignmod.block.PrivatedoorBlock;
import net.mcreator.reignmod.block.entity.PrivatedoorBlockEntity;
import net.mcreator.reignmod.claim.capital.CapitalClaimProtectionHandler;
import net.mcreator.reignmod.claim.capital.CapitalClaimSavedData;
import net.mcreator.reignmod.house.HouseManager;
import net.mcreator.reignmod.kingdom.KingdomManager;
import net.mcreator.reignmod.networking.ReignNetworking;
import net.mcreator.reignmod.procedures.IsKingProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class DoorOpenPermissionQueryC2SPacket {
    private final BlockPos pos;

    public DoorOpenPermissionQueryC2SPacket(BlockPos pos) {
        this.pos = pos;
    }

    public DoorOpenPermissionQueryC2SPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            if (sender == null) {
                return;
            }
            Level world = sender.m_9236_();
            BlockEntity be = world.m_7702_(this.pos);
            boolean canOpen = true;
            if (be instanceof PrivatedoorBlockEntity) {
                CompoundTag tag;
                PrivatedoorBlockEntity door = (PrivatedoorBlockEntity)be;
                if (world.m_8055_(this.pos).m_60734_() instanceof PrivatedoorBlock && (tag = door.getPersistentData()).m_128441_("owner")) {
                    String lockType;
                    String owner = tag.m_128461_("owner");
                    canOpen = switch (lockType = tag.m_128461_("lock_type")) {
                        case "personal" -> sender.m_20149_().equals(owner);
                        case "domain" -> {
                            if (sender.m_20149_().equals(owner) || Objects.equals(HouseManager.getDomainLordByKnight(owner), sender.m_20149_()) || Objects.equals(HouseManager.getPlayerDomainKnight((Player)sender), owner)) {
                                yield true;
                            }
                            yield false;
                        }
                        case "house" -> Objects.equals(HouseManager.getPlayerHouseLord((Player)sender), owner);
                        case "prison" -> {
                            if (CapitalClaimProtectionHandler.isMarshal(sender) || CapitalClaimProtectionHandler.isKingOrHand(sender)) {
                                yield true;
                            }
                            yield false;
                        }
                        case "royal" -> {
                            if (KingdomManager.isPlayerInCourt(sender.m_20149_()) || IsKingProcedure.execute((LevelAccessor)CapitalClaimSavedData.getInstance().getServerLevelInstance(), (Entity)sender)) {
                                yield true;
                            }
                            yield false;
                        }
                        default -> false;
                    };
                }
            }
            ReignNetworking.sendDoorOpenPermissionSync(sender, this.pos, canOpen);
        });
        ctx.setPacketHandled(true);
    }
}

