/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.networking.packet.S2C;

import java.util.function.Supplier;
import net.mcreator.reignmod.networking.ClientPlayerData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ChunkBreakPermissionSyncS2CPacket {
    private final int chunkX;
    private final int chunkZ;
    private final boolean canBreak;
    private final int houseLevel;
    private final boolean warStateEnabled;
    private final boolean siegeStateEnabled;

    public ChunkBreakPermissionSyncS2CPacket(int chunkX, int chunkZ, boolean canBreak, boolean warStateEnabled, boolean siegeStateEnabled, int houseLevel) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.canBreak = canBreak;
        this.houseLevel = houseLevel;
        this.warStateEnabled = warStateEnabled;
        this.siegeStateEnabled = siegeStateEnabled;
    }

    public ChunkBreakPermissionSyncS2CPacket(FriendlyByteBuf buf) {
        this.chunkX = buf.readInt();
        this.chunkZ = buf.readInt();
        this.houseLevel = buf.readInt();
        this.canBreak = buf.readBoolean();
        this.warStateEnabled = buf.readBoolean();
        this.siegeStateEnabled = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.chunkX);
        buf.writeInt(this.chunkZ);
        buf.writeInt(this.houseLevel);
        buf.writeBoolean(this.canBreak);
        buf.writeBoolean(this.warStateEnabled);
        buf.writeBoolean(this.siegeStateEnabled);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> ClientPlayerData.setLastKnownChunk(this.chunkX, this.chunkZ, this.canBreak, this.warStateEnabled, this.siegeStateEnabled, this.houseLevel));
    }
}

