/*
 * Decompiled with CFR 0.152.
 */
package com.skps2010;

import com.skps2010.CravingPayload;
import com.skps2010.CravingState;
import com.skps2010.FDConfigs;
import com.skps2010.FoodHistoryPayload;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.StreamSupport;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_10124;
import net.minecraft.class_10132;
import net.minecraft.class_10134;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_4081;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public final class CravingManager {
    private static volatile List<class_1792> allowedFoods = List.of();

    private CravingManager() {
    }

    public static void rebuildAllowedFoods() {
        allowedFoods = StreamSupport.stream(class_7923.field_41178.spliterator(), false).filter(i -> i.method_57347().method_58694(class_9334.field_50075) != null).filter(i -> !CravingManager.hasNegativeEffect(i)).toList();
    }

    private static boolean hasNegativeEffect(class_1792 item) {
        class_10124 cc = (class_10124)item.method_57347().method_58694(class_9334.field_53964);
        if (cc == null) {
            return false;
        }
        for (class_10134 ce : cc.comp_3089()) {
            if (!(ce instanceof class_10132)) continue;
            class_10132 a = (class_10132)ce;
            for (class_1293 inst : a.comp_3094()) {
                if (((class_1291)inst.method_5579().comp_349()).method_18792() != class_4081.field_18272) continue;
                return true;
            }
        }
        return false;
    }

    private static Optional<String> pickRandomAllowedId() {
        List<class_1792> pool;
        if (allowedFoods.isEmpty()) {
            CravingManager.rebuildAllowedFoods();
        }
        if ((pool = allowedFoods).isEmpty()) {
            return Optional.empty();
        }
        class_1792 it = pool.get(ThreadLocalRandom.current().nextInt(pool.size()));
        return Optional.of(class_7923.field_41178.method_10221((Object)it).toString());
    }

    public static CravingState.Entry ensureCraving(class_3222 p) {
        CravingState st = CravingState.get(p.method_51469().method_8503());
        long now = p.method_51469().method_8510();
        CravingState.Entry e = st.get(p.method_5667());
        if (e == null || now >= e.nextChangeTick()) {
            e = CravingManager.rerollCraving(p, now);
        }
        return e;
    }

    public static void onConsume(class_3222 p, class_1799 stack) {
        CravingState.Entry e = CravingManager.ensureCraving(p);
        String id = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
        if (!id.equals(e.itemId())) {
            return;
        }
        CravingState st = CravingState.get(p.method_51469().method_8503());
        int c = e.eatenInRound() + 1;
        st.set(p.method_5667(), new CravingState.Entry(e.itemId(), e.nextChangeTick(), c));
        if (c >= FDConfigs.CFG.cravingMaxCount) {
            CravingManager.rerollCraving(p, p.method_51469().method_8510());
        }
    }

    public static boolean isCraving(class_3222 p, class_1792 item) {
        CravingState.Entry e = CravingManager.ensureCraving(p);
        String id = class_7923.field_41178.method_10221((Object)item).toString();
        return id.equals(e.itemId());
    }

    public static String getCurrentCravingItem(MinecraftServer server, UUID uuid) {
        CravingState.Entry e = CravingState.get(server).get(uuid);
        if (e == null) {
            return "";
        }
        return e.itemId();
    }

    private static CravingState.Entry rerollCraving(class_3222 p, long now) {
        CravingState st = CravingState.get(p.method_51469().method_8503());
        String id = CravingManager.pickRandomAllowedId().orElse("minecraft:bread");
        long next = now + FDConfigs.CFG.cravingChangeInterval;
        CravingState.Entry e = new CravingState.Entry(id, next, 0);
        st.set(p.method_5667(), e);
        ServerPlayNetworking.send((class_3222)p, (class_8710)new CravingPayload(id));
        ServerPlayNetworking.send((class_3222)p, (class_8710)new FoodHistoryPayload(p));
        return e;
    }

    public static void tickCraving(class_3222 p, long now) {
        CravingState st = CravingState.get(p.method_51469().method_8503());
        CravingState.Entry e = st.get(p.method_5667());
        if (e == null || now >= e.nextChangeTick()) {
            CravingManager.rerollCraving(p, now);
        }
    }
}

