/*
 * Decompiled with CFR 0.152.
 */
package com.skps2010;

import com.skps2010.CravingManager;
import com.skps2010.FDConfig;
import com.skps2010.FDConfigs;
import com.skps2010.FoodHistoryState;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record FoodHistoryPayload(Map<String, FoodInfo> map) implements class_8710
{
    public static final class_8710.class_9154<FoodHistoryPayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"crave_and_feast", (String)"crave_and_feast_sync"));
    private static final class_9139<class_9129, FoodInfo> INFO_CODEC = class_9139.method_56435((class_9139)class_9135.field_48552, FoodInfo::multiplier, (class_9139)class_9135.field_48554, FoodInfo::display, FoodInfo::new);
    public static final class_9139<class_9129, FoodHistoryPayload> CODEC = class_9139.method_56434((class_9139)class_9135.method_56377(HashMap::new, (class_9139)class_9135.field_48554, INFO_CODEC), FoodHistoryPayload::map, FoodHistoryPayload::new);

    public FoodHistoryPayload(class_3222 player) {
        this(FoodHistoryPayload.makeMap(player));
    }

    private static Map<String, FoodInfo> makeMap(class_3222 player) {
        FDConfig cfg = FDConfigs.CFG;
        FoodHistoryState state = FoodHistoryState.get(player.method_51469().method_8503());
        List<String> history = state.getHistory((class_1657)player);
        String cravingId = CravingManager.getCurrentCravingItem(player.method_51469().method_8503(), player.method_5667());
        Map<String, Long> counts = history.stream().collect(Collectors.groupingBy(s -> s, Collectors.counting()));
        HashMap<String, FoodInfo> map = new HashMap<String, FoodInfo>();
        for (Map.Entry<String, Long> e : counts.entrySet()) {
            String disp;
            float mult;
            String foodId = e.getKey();
            int count = e.getValue().intValue();
            if (foodId.equals(cravingId)) {
                mult = cfg.cravingMultiplier;
                disp = cfg.cravingDisplay;
            } else {
                mult = 1.0f;
                disp = "";
                for (FDConfig.Rule r : cfg.rules) {
                    if (r.maxCount >= 0 && count > r.maxCount) continue;
                    mult = r.multiplier;
                    disp = r.display;
                    break;
                }
            }
            map.put(foodId, new FoodInfo(mult, disp));
        }
        if (cravingId != null) {
            map.put(cravingId, new FoodInfo(cfg.cravingMultiplier, cfg.cravingDisplay));
        }
        FDConfig.Rule first = cfg.rules.getFirst();
        map.put("default", new FoodInfo(first.multiplier, first.display));
        return map;
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    public record FoodInfo(float multiplier, String display) {
    }
}

