/*
 * Decompiled with CFR 0.152.
 */
package net.zynwro.afk;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Random;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1659;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5498;
import net.minecraft.class_7172;
import net.zynwro.afk.AfkScreen;
import org.joml.Matrix3x2fStack;
import org.lwjgl.glfw.GLFW;

public class AfkCore
implements ClientModInitializer {
    public static final String MOD_ID = "afk";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("afk.json");
    public static Config CONFIG = Config.load(CONFIG_PATH);
    public static boolean isAfk;
    private static boolean fpsCapped;
    private static long lastActiveMs;
    private static long afkStartMs;
    private static double lastX;
    private static double lastY;
    private static double lastZ;
    private static double lastYaw;
    private static double lastPitch;
    private static final class_304.class_11900 KB_CAT;
    private static class_304 toggleKey;
    private static class_304 uiKey;
    private static class_304 forceKey;
    private static class_304 styleKey;
    public static boolean camActive;
    private static class_5498 prevPerspective;
    private static boolean prevSmoothCam;
    private static int prevFov;
    private static class_1659 prevChatVisibility;
    private static final Random RNG;
    private static float playerYawNow;
    private static final double R_MIN_SAFE = 2.0;
    private static final double R_MAX_SAFE = 12.0;
    private static final double PITCH_MIN = -55.0;
    private static final double PITCH_MAX = 75.0;
    private static final double CLEAR_GROUND = 0.34;
    private static final double HOFF_MIN = 0.44;
    private static final double HOFF_MAX = 0.72;
    private static double radius;
    private static double relYawDeg;
    private static double pitchDeg;
    private static double heightOff;
    private static long lastTickMs;
    private static final int CAMS = 16;
    private static double[][] kfFrom;
    private static double[][] kfTo;
    private static long segStartMs;
    private static int segIndex;
    private static int mode;
    private static boolean modeBlend;
    private static double blendTargetR;
    private static double blendTargetYaw;
    private static double blendTargetPit;
    private static double blendTargetH;
    private static double spinYawDeg;
    private static double spinSpeedDegSec;
    private static double spinR;
    private static double spinPit;
    private static double spinH;
    private static final double BLEND_TAU_R = 0.55;
    private static final double BLEND_TAU_Y = 0.55;
    private static final double BLEND_TAU_P = 0.55;
    private static final double BLEND_TAU_H = 0.55;
    private static final double CINE_TAU_R = 0.6;
    private static final double CINE_TAU_Y = 0.65;
    private static final double CINE_TAU_P = 0.65;
    private static final double CINE_TAU_H = 0.65;
    private static final double ORB_TAU_R = 0.95;
    private static final double ORB_TAU_P = 0.95;
    private static final double ORB_TAU_H = 0.95;
    private static double velR;
    private static double velY;
    private static double velP;
    private static double velH;
    private static long ignoreActivityUntilMs;
    private static long forceUnlimitedUntilMs;

    public void onInitializeClient() {
        CONFIG = Config.load(CONFIG_PATH);
        class_310 mcBoot = class_310.method_1551();
        if (mcBoot != null && AfkCore.CONFIG.afkWasActive) {
            int restore = AfkCore.CONFIG.lastUserFov != null ? AfkCore.CONFIG.lastUserFov : 70;
            try {
                mcBoot.field_1690.method_41808().method_41748((Object)restore);
                mcBoot.field_1690.method_1640();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            AfkCore.CONFIG.afkWasActive = false;
            AfkCore.saveConfig();
        }
        toggleKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.afk.toggle", class_3675.class_307.field_1668, 78, KB_CAT));
        uiKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.afk.ui", class_3675.class_307.field_1668, 77, KB_CAT));
        forceKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.afk.force", class_3675.class_307.field_1668, 66, KB_CAT));
        styleKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.afk.style", class_3675.class_307.field_1668, 86, KB_CAT));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (toggleKey.method_1436()) {
                boolean old = AfkCore.CONFIG.enabled;
                AfkCore.CONFIG.enabled = !AfkCore.CONFIG.enabled;
                AfkCore.saveConfig();
                if (client.field_1724 != null && old != AfkCore.CONFIG.enabled) {
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)(AfkCore.CONFIG.enabled ? "[AFK] Enabled" : "[AFK] Disabled")), true);
                }
                if (AfkCore.CONFIG.enabled || !isAfk) continue;
                AfkCore.clearAfk(client);
            }
            while (uiKey.method_1436()) {
                if (client == null) continue;
                if (client.field_1755 instanceof AfkScreen) {
                    client.method_1507(null);
                    AfkCore.suppressActivityShort();
                    continue;
                }
                client.method_1507((class_437)new AfkScreen((class_2561)class_2561.method_43470((String)"AFK Station")));
                AfkCore.suppressActivityShort();
            }
            while (forceKey.method_1436() && client != null && client.field_1724 != null) {
                if (!AfkCore.CONFIG.enabled) {
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"[AFK] Mod is disabled"), true);
                    break;
                }
                long now = System.currentTimeMillis();
                if (!isAfk) {
                    isAfk = true;
                    afkStartMs = now;
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"[AFK] You are now AFK"), true);
                    AfkCore.applyAfkFpsCap(client);
                    AfkCore.applyAfkChatHide(client);
                    AfkCore.startDirector(client);
                    continue;
                }
                AfkCore.clearAfk(client);
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"[AFK] You are no longer AFK"), true);
            }
            while (styleKey.method_1436() && client != null) {
                if (!AfkCore.CONFIG.cameraEnabled) {
                    if (client.field_1724 == null) continue;
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"[AFK] Camera: Off"), true);
                    continue;
                }
                AfkCore.CONFIG.cameraStyle = (AfkCore.CONFIG.cameraStyle + 1) % 2;
                AfkCore.saveConfig();
                if (client.field_1724 != null) {
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("[AFK] " + AfkCore.styleLabel(AfkCore.CONFIG.cameraStyle))), true);
                }
                AfkCore.ensureModeBlend();
            }
            if (client == null || client.field_1724 == null || client.method_1493()) {
                return;
            }
            boolean anyActivity = AfkCore.detectAnyActivity(client);
            double px = client.field_1724.method_23317();
            double py = client.field_1724.method_23318();
            double pz = client.field_1724.method_23321();
            double yaw = client.field_1724.method_36454();
            double pitch = client.field_1724.method_36455();
            boolean posMoved = px != lastX || py != lastY || pz != lastZ;
            boolean rotMoved = yaw != lastYaw || pitch != lastPitch;
            boolean movedRaw = posMoved || rotMoved || anyActivity;
            long now = System.currentTimeMillis();
            if (movedRaw) {
                AfkCore.forceUnlimitedFps(client);
                forceUnlimitedUntilMs = now + 500L;
            }
            boolean moved = movedRaw;
            if (now < ignoreActivityUntilMs) {
                moved = false;
            }
            if (moved) {
                lastActiveMs = now;
                if (isAfk) {
                    AfkCore.clearAfk(client);
                }
            } else if (AfkCore.CONFIG.enabled) {
                long idleMs = now - lastActiveMs;
                if (!isAfk && idleMs >= (long)AfkCore.CONFIG.timeoutSeconds * 1000L) {
                    isAfk = true;
                    afkStartMs = now;
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"[AFK] You are now AFK"), true);
                    AfkCore.applyAfkFpsCap(client);
                    AfkCore.applyAfkChatHide(client);
                    AfkCore.startDirector(client);
                } else if (isAfk) {
                    if (fpsCapped && now >= forceUnlimitedUntilMs) {
                        AfkCore.setMaxFps(client, Math.max(10, Math.min(260, AfkCore.CONFIG.afkFpsCap)));
                    }
                    playerYawNow = client.field_1724.method_36454();
                    AfkCore.updateDirector(now);
                }
            }
            lastX = px;
            lastY = py;
            lastZ = pz;
            lastYaw = yaw;
            lastPitch = pitch;
        });
        HudElementRegistry.addLast((class_2960)class_2960.method_60655((String)MOD_ID, (String)"afk_time"), (ctx, tickCounter) -> {
            if (!isAfk || !AfkCore.CONFIG.hudEnabled) {
                return;
            }
            class_310 mc = class_310.method_1551();
            if (mc == null || mc.field_1724 == null || mc.method_1493()) {
                return;
            }
            long secs = Math.max(0L, (System.currentTimeMillis() - afkStartMs) / 1000L);
            String title = "AFK Time";
            String time = AfkCore.formatHMS(secs);
            float scale = (float)AfkCore.CONFIG.hudScale;
            int sw = mc.method_22683().method_4486();
            int sh = mc.method_22683().method_4502();
            Objects.requireNonNull(mc.field_1772);
            int fh = 9;
            int wTitle = mc.field_1772.method_1727(title);
            int wTime = mc.field_1772.method_1727(time);
            float titleScale = 2.0f * scale;
            float timeScale = 2.6f * scale;
            float titlePxWidth = (float)wTitle * titleScale;
            float timePxWidth = (float)wTime * timeScale;
            float titlePxHeight = (float)fh * titleScale;
            float timePxHeight = (float)fh * timeScale;
            float totalHeight = titlePxHeight + 6.0f * scale + timePxHeight;
            float x = switch (AfkCore.CONFIG.hudAnchor.ordinal()) {
                case 1, 3 -> 12.0f * scale;
                case 2, 4 -> (float)sw - Math.max(titlePxWidth, timePxWidth) - 12.0f * scale;
                case 5 -> (float)((double)sw * AfkCore.CONFIG.hudXPercent);
                default -> ((float)sw - Math.max(titlePxWidth, timePxWidth)) / 2.0f;
            };
            float y = switch (AfkCore.CONFIG.hudAnchor.ordinal()) {
                case 1, 2 -> 12.0f * scale;
                case 3, 4 -> (float)sh - totalHeight - 12.0f * scale;
                case 5 -> (float)((double)sh * AfkCore.CONFIG.hudYPercent);
                default -> ((float)sh - totalHeight) / 2.0f;
            };
            int xTitle = Math.round(x / titleScale);
            int yTitle = Math.round(y / titleScale);
            int xTime = Math.round((x + (Math.max(titlePxWidth, timePxWidth) - timePxWidth) / 2.0f) / timeScale);
            int yTime = Math.round((y + titlePxHeight + 6.0f * scale) / timeScale);
            Matrix3x2fStack m = ctx.method_51448();
            m.pushMatrix();
            m.scale(titleScale, titleScale);
            ctx.method_25303(mc.field_1772, title, xTitle, yTitle, -1);
            m.popMatrix();
            m.pushMatrix();
            m.scale(timeScale, timeScale);
            ctx.method_25303(mc.field_1772, time, xTime, yTime, -1);
            m.popMatrix();
        });
        lastActiveMs = System.currentTimeMillis();
    }

    private static boolean detectAnyActivity(class_310 client) {
        long win;
        if (client.field_1755 instanceof AfkScreen) {
            return false;
        }
        boolean keyMoving = client.field_1690.field_1894.method_1434() || client.field_1690.field_1881.method_1434() || client.field_1690.field_1913.method_1434() || client.field_1690.field_1849.method_1434() || client.field_1690.field_1903.method_1434() || client.field_1690.field_1832.method_1434() || client.field_1690.field_1867.method_1434();
        boolean actionKeys = client.field_1690.field_1886.method_1434() || client.field_1690.field_1904.method_1434() || client.field_1690.field_1871.method_1434() || client.field_1690.field_1869.method_1434() || client.field_1690.field_1822.method_1434() || client.field_1690.field_1831.method_1434();
        boolean hotbar = false;
        if (client.field_1690.field_1852 != null) {
            for (class_304 k : client.field_1690.field_1852) {
                if (k == null || !k.method_1434()) continue;
                hotbar = true;
                break;
            }
        }
        boolean mousePressed = GLFW.glfwGetMouseButton((long)(win = client.method_22683().method_4490()), (int)0) == 1 || GLFW.glfwGetMouseButton((long)win, (int)1) == 1 || GLFW.glfwGetMouseButton((long)win, (int)2) == 1;
        return keyMoving || actionKeys || hotbar || mousePressed;
    }

    private static String formatHMS(long secs) {
        long h = secs / 3600L;
        long m = secs % 3600L / 60L;
        long s = secs % 60L;
        return h > 0L ? String.format("%d:%02d:%02d", h, m, s) : String.format("%02d:%02d", m, s);
    }

    private static void setMaxFps(class_310 client, int value) {
        class_7172 opt = client.field_1690.method_42524();
        if (!((Integer)opt.method_41753()).equals(value)) {
            opt.method_41748((Object)value);
            client.field_1690.method_1640();
        }
    }

    private static void forceUnlimitedFps(class_310 client) {
        try {
            AfkCore.setMaxFps(client, 260);
            fpsCapped = false;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void applyAfkFpsCap(class_310 client) {
        try {
            AfkCore.setMaxFps(client, Math.max(10, Math.min(260, AfkCore.CONFIG.afkFpsCap)));
            fpsCapped = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void applyAfkChatHide(class_310 client) {
        try {
            if (AfkCore.CONFIG.chatHideWhileAfk) {
                class_7172 opt = client.field_1690.method_42539();
                prevChatVisibility = (class_1659)opt.method_41753();
                opt.method_41748((Object)class_1659.field_7536);
                client.field_1690.method_1643();
                client.field_1690.method_1640();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void restoreChatVisibility(class_310 client) {
        try {
            if (prevChatVisibility != null) {
                class_7172 opt = client.field_1690.method_42539();
                opt.method_41748((Object)prevChatVisibility);
                client.field_1690.method_1643();
                client.field_1690.method_1640();
                prevChatVisibility = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void clearAfk(class_310 client) {
        isAfk = false;
        try {
            AfkCore.setMaxFps(client, 260);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        AfkCore.restoreChatVisibility(client);
        AfkCore.stopDirector(client);
        fpsCapped = false;
    }

    private static void startDirector(class_310 mc) {
        long now;
        if (!AfkCore.CONFIG.cameraEnabled) {
            return;
        }
        prevPerspective = mc.field_1690.method_31044();
        prevSmoothCam = mc.field_1690.field_1914;
        prevFov = (Integer)mc.field_1690.method_41808().method_41753();
        AfkCore.CONFIG.lastUserFov = prevFov;
        AfkCore.CONFIG.afkWasActive = true;
        AfkCore.saveConfig();
        mc.field_1690.field_1914 = true;
        mc.field_1690.method_31043(class_5498.field_26665);
        mc.field_1690.method_41808().method_41748((Object)Math.max(30, Math.min(120, AfkCore.CONFIG.afkFov)));
        kfFrom = new double[16][4];
        kfTo = new double[16][4];
        double nearK = AfkCore.CONFIG.cameraCloseUp ? 0.78 : 1.0;
        double farK = AfkCore.CONFIG.cameraCloseUp ? 0.9 : 1.0;
        AfkCore.kfFrom[0] = new double[]{3.4 * nearK, 90.0, -8.0, 0.52};
        AfkCore.kfTo[0] = new double[]{3.8 * nearK, 110.0, -4.0, 0.54};
        AfkCore.kfFrom[1] = new double[]{4.8 * farK, 120.0, 52.0, 0.62};
        AfkCore.kfTo[1] = new double[]{5.6 * farK, 145.0, 56.0, 0.66};
        AfkCore.kfFrom[2] = new double[]{3.6 * nearK, 270.0, -6.0, 0.54};
        AfkCore.kfTo[2] = new double[]{4.0 * nearK, 290.0, -2.0, 0.56};
        AfkCore.kfFrom[3] = new double[]{3.8 * nearK, 180.0, -8.0, 0.54};
        AfkCore.kfTo[3] = new double[]{4.2 * nearK, 200.0, -4.0, 0.58};
        AfkCore.kfFrom[4] = new double[]{3.4 * nearK, 330.0, -4.0, 0.54};
        AfkCore.kfTo[4] = new double[]{3.8 * nearK, 350.0, 0.0, 0.56};
        AfkCore.kfFrom[5] = new double[]{2.2, 20.0, -40.0, 0.46};
        AfkCore.kfTo[5] = new double[]{2.5, 40.0, -30.0, 0.5};
        AfkCore.kfFrom[6] = new double[]{2.1, 90.0, -48.0, 0.46};
        AfkCore.kfTo[6] = new double[]{2.4, 100.0, -38.0, 0.5};
        AfkCore.kfFrom[7] = new double[]{11.0 * farK, 110.0, 24.0, 0.62};
        AfkCore.kfTo[7] = new double[]{12.0 * farK, 135.0, 36.0, 0.68};
        AfkCore.kfFrom[8] = new double[]{2.0, 88.0, -22.0, 0.48};
        AfkCore.kfTo[8] = new double[]{2.2, 92.0, -8.0, 0.5};
        AfkCore.kfFrom[9] = new double[]{1.85, 94.0, -28.0, 0.48};
        AfkCore.kfTo[9] = new double[]{2.05, 96.0, -12.0, 0.5};
        AfkCore.kfFrom[10] = new double[]{3.6 * nearK, 140.0, -10.0, 0.54};
        AfkCore.kfTo[10] = new double[]{4.0 * nearK, 160.0, -6.0, 0.58};
        AfkCore.kfFrom[11] = new double[]{3.4 * nearK, 70.0, -8.0, 0.52};
        AfkCore.kfTo[11] = new double[]{3.8 * nearK, 90.0, -4.0, 0.56};
        AfkCore.kfFrom[12] = new double[]{2.3, 85.0, -52.0, 0.46};
        AfkCore.kfTo[12] = new double[]{2.5, 95.0, -46.0, 0.48};
        AfkCore.kfFrom[13] = new double[]{2.6, 115.0, -36.0, 0.46};
        AfkCore.kfTo[13] = new double[]{2.9, 135.0, -30.0, 0.5};
        AfkCore.kfFrom[14] = new double[]{4.2 * farK, 210.0, 18.0, 0.56};
        AfkCore.kfTo[14] = new double[]{5.0 * farK, 240.0, 28.0, 0.6};
        AfkCore.kfFrom[15] = new double[]{2.0, 92.0, -16.0, 0.5};
        AfkCore.kfTo[15] = new double[]{2.2, 92.0, -6.0, 0.52};
        segIndex = 0;
        AfkCore.applyCut(kfFrom[0]);
        segStartMs = now = System.currentTimeMillis();
        lastTickMs = now;
        spinR = AfkCore.CONFIG.cameraCloseUp ? 5.8 : 7.2;
        spinYawDeg = relYawDeg % 360.0;
        if (spinYawDeg < 0.0) {
            spinYawDeg += 360.0;
        }
        spinSpeedDegSec = 22.0 + RNG.nextDouble() * 6.0;
        spinPit = AfkCore.CONFIG.cameraCloseUp ? 4.0 : 6.0;
        spinH = 0.52;
        mode = AfkCore.CONFIG.cameraStyle == 0 ? 0 : 1;
        modeBlend = false;
        velH = 0.0;
        velP = 0.0;
        velY = 0.0;
        velR = 0.0;
        camActive = true;
        AfkCore.enforceGroundClearance();
    }

    private static void stopDirector(class_310 mc) {
        if (!camActive) {
            return;
        }
        mc.field_1690.field_1914 = prevSmoothCam;
        mc.field_1690.method_31043(prevPerspective);
        mc.field_1690.method_41808().method_41748((Object)prevFov);
        AfkCore.CONFIG.afkWasActive = false;
        AfkCore.saveConfig();
        camActive = false;
    }

    private static double mix(double a, double b, double t) {
        return a + (b - a) * t;
    }

    private static void applyCut(double[] rig) {
        double wantR = AfkCore.clamp(rig[0], 2.0, 12.0);
        double wantYaw = rig[1];
        double wantPit = AfkCore.clamp(rig[2], -55.0, 75.0);
        double wantH = rig[3];
        radius = wantR;
        relYawDeg = wantYaw;
        pitchDeg = wantPit;
        heightOff = wantH;
        AfkCore.enforceGroundClearance();
    }

    private static double damp(double current, double target, double[] vRef, double tau, double dt) {
        double omega = 2.0 / Math.max(1.0E-4, tau);
        double x = omega * dt;
        double exp = 1.0 / (1.0 + x + 0.48 * x * x + 0.235 * x * x * x);
        double change = current - target;
        double temp = (vRef[0] + omega * change) * dt;
        vRef[0] = (vRef[0] - omega * temp) * exp;
        return target + (change + temp) * exp;
    }

    private static void ensureModeBlend() {
        int want;
        int n = want = AfkCore.CONFIG.cameraStyle == 0 ? 0 : 1;
        if (want == mode) {
            return;
        }
        mode = want;
        if (!camActive) {
            return;
        }
        modeBlend = true;
        if (mode == 0) {
            double[] nextRig = kfFrom[segIndex];
            blendTargetR = AfkCore.clamp(nextRig[0], 2.0, 12.0);
            blendTargetYaw = nextRig[1];
            blendTargetPit = AfkCore.clamp(nextRig[2], -55.0, 75.0);
            blendTargetH = nextRig[3];
        } else {
            spinYawDeg = relYawDeg % 360.0;
            if (spinYawDeg < 0.0) {
                spinYawDeg += 360.0;
            }
            blendTargetR = spinR;
            blendTargetYaw = spinYawDeg;
            blendTargetPit = spinPit;
            blendTargetH = spinH;
        }
        AfkCore.enforceGroundClearance();
    }

    private static void updateDirector(long now) {
        if (!camActive || !AfkCore.CONFIG.cameraEnabled) {
            return;
        }
        long dtMs = Math.max(1L, now - lastTickMs);
        lastTickMs = now;
        double dt = Math.min(0.05, (double)dtMs / 1000.0);
        AfkCore.ensureModeBlend();
        if (modeBlend) {
            double[] vr = new double[]{velR};
            double[] vy = new double[]{velY};
            double[] vp = new double[]{velP};
            double[] vh = new double[]{velH};
            radius = AfkCore.damp(radius, blendTargetR, vr, 0.55, dt);
            relYawDeg = AfkCore.damp(relYawDeg, blendTargetYaw, vy, 0.55, dt);
            pitchDeg = AfkCore.damp(pitchDeg, blendTargetPit, vp, 0.55, dt);
            heightOff = AfkCore.damp(heightOff, blendTargetH, vh, 0.55, dt);
            velR = vr[0];
            velY = vy[0];
            velP = vp[0];
            velH = vh[0];
            AfkCore.enforceGroundClearance();
            if (Math.abs(radius - blendTargetR) < 0.01 && Math.abs(relYawDeg - blendTargetYaw) < 0.05 && Math.abs(pitchDeg - blendTargetPit) < 0.05 && Math.abs(heightOff - blendTargetH) < 0.005) {
                modeBlend = false;
                velH = 0.0;
                velP = 0.0;
                velY = 0.0;
                velR = 0.0;
            }
            return;
        }
        if (mode == 0) {
            if (now - segStartMs >= 5000L) {
                segIndex = (segIndex + 1) % 16;
                AfkCore.applyCut(kfFrom[segIndex]);
                segStartMs = now;
            }
            double t = Math.max(0.0, Math.min(1.0, (double)(now - segStartMs) / 5000.0));
            double wantR = AfkCore.clamp(AfkCore.mix(kfFrom[segIndex][0], kfTo[segIndex][0], t), 2.0, 12.0);
            double wantYaw = AfkCore.angleMixDeg(kfFrom[segIndex][1], kfTo[segIndex][1], t);
            double wantPit = AfkCore.clamp(AfkCore.mix(kfFrom[segIndex][2], kfTo[segIndex][2], t), -55.0, 75.0);
            double wantH = AfkCore.mix(kfFrom[segIndex][3], kfTo[segIndex][3], t);
            double[] vr = new double[]{velR};
            double[] vy = new double[]{velY};
            double[] vp = new double[]{velP};
            double[] vh = new double[]{velH};
            radius = AfkCore.damp(radius, wantR, vr, 0.6, dt);
            relYawDeg = AfkCore.damp(relYawDeg, wantYaw, vy, 0.65, dt);
            pitchDeg = AfkCore.damp(pitchDeg, wantPit, vp, 0.65, dt);
            heightOff = AfkCore.damp(heightOff, wantH, vh, 0.65, dt);
            velR = vr[0];
            velY = vy[0];
            velP = vp[0];
            velH = vh[0];
            AfkCore.enforceGroundClearance();
        } else {
            spinYawDeg = (spinYawDeg + spinSpeedDegSec * dt) % 360.0;
            double wantR = spinR;
            double wantYaw = spinYawDeg;
            double wantPit = spinPit;
            double wantH = spinH;
            double[] vr = new double[]{velR};
            double[] vp = new double[]{velP};
            double[] vh = new double[]{velH};
            radius = AfkCore.damp(radius, wantR, vr, 0.95, dt);
            relYawDeg = wantYaw;
            pitchDeg = AfkCore.damp(pitchDeg, AfkCore.clamp(wantPit, -55.0, 75.0), vp, 0.95, dt);
            heightOff = AfkCore.damp(heightOff, wantH, vh, 0.95, dt);
            velR = vr[0];
            velP = vp[0];
            velH = vh[0];
            AfkCore.enforceGroundClearance();
        }
    }

    private static void enforceGroundClearance() {
        double minCamY;
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null) {
            return;
        }
        double minY = mc.field_1724.method_5829().field_1322;
        double maxY = mc.field_1724.method_5829().field_1325;
        double base = minY + (maxY - minY) * 0.6;
        double pitchRad = Math.toRadians(pitchDeg);
        double camY = base + heightOff + radius * Math.sin(pitchRad);
        if (camY < (minCamY = minY + 0.34)) {
            double need = minCamY - camY + 0.02;
            heightOff = AfkCore.clamp(heightOff + need, 0.44, 0.72);
        } else {
            heightOff = AfkCore.clamp(heightOff, 0.44, 0.72);
        }
    }

    private static float getPlayerYaw() {
        class_310 mc = class_310.method_1551();
        return mc != null && mc.field_1724 != null ? mc.field_1724.method_36454() : playerYawNow;
    }

    public static OrbitState getOrbit() {
        double baseYaw = AfkCore.getPlayerYaw();
        double camYawDeg = baseYaw + relYawDeg;
        return new OrbitState(radius, Math.toRadians(camYawDeg), Math.toRadians(pitchDeg), heightOff);
    }

    public static boolean isCinematicActive() {
        return isAfk && camActive;
    }

    public static void saveConfig() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)CONFIG), new OpenOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void suppressActivityShort() {
        ignoreActivityUntilMs = System.currentTimeMillis() + 600L;
    }

    public static void enforceDisableEffect() {
        class_310 mc = class_310.method_1551();
        if (mc != null && !AfkCore.CONFIG.enabled && isAfk) {
            AfkCore.clearAfk(mc);
        }
    }

    private static double clamp(double v, double lo, double hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    private static double angleMixDeg(double a, double b, double t) {
        double d = AfkCore.wrapDegrees(b - a);
        return a + d * t;
    }

    private static double wrapDegrees(double d) {
        if ((d %= 360.0) > 180.0) {
            d -= 360.0;
        }
        if (d < -180.0) {
            d += 360.0;
        }
        return d;
    }

    private static String styleLabel(int style) {
        return style == 0 ? "Style: Cinematic" : "Style: Orbit";
    }

    static {
        KB_CAT = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)MOD_ID, (String)"main"));
        RNG = new Random();
        radius = 3.6;
        relYawDeg = 150.0;
        pitchDeg = -6.0;
        heightOff = 0.5;
        mode = 0;
    }

    public static class Config {
        public boolean enabled = true;
        public int timeoutSeconds = 30;
        public int afkFpsCap = 30;
        public boolean cameraEnabled = true;
        public int cameraStyle = 0;
        public boolean cameraCloseUp = false;
        public boolean hudEnabled = true;
        public Anchor hudAnchor = Anchor.CENTER;
        public double hudXPercent = 0.5;
        public double hudYPercent = 0.5;
        public double hudScale = 1.0;
        public int afkFov = 30;
        public boolean chatHideWhileAfk = false;
        public Integer lastUserFov = null;
        public boolean afkWasActive = false;

        public static Config load(Path path) {
            try {
                if (Files.exists(path, new LinkOption[0])) {
                    String s = Files.readString(path);
                    Gson g = new GsonBuilder().create();
                    Config c = (Config)g.fromJson(s, Config.class);
                    if (c == null) {
                        c = new Config();
                    }
                    c.timeoutSeconds = Math.max(5, Math.min(600, c.timeoutSeconds));
                    c.afkFpsCap = Math.max(10, Math.min(260, c.afkFpsCap));
                    if (c.hudScale < 0.6) {
                        c.hudScale = 0.6;
                    }
                    if (c.hudScale > 2.0) {
                        c.hudScale = 2.0;
                    }
                    if (c.hudXPercent < 0.0) {
                        c.hudXPercent = 0.0;
                    }
                    if (c.hudXPercent > 1.0) {
                        c.hudXPercent = 1.0;
                    }
                    if (c.hudYPercent < 0.0) {
                        c.hudYPercent = 0.0;
                    }
                    if (c.hudYPercent > 1.0) {
                        c.hudYPercent = 1.0;
                    }
                    if (c.cameraStyle < 0 || c.cameraStyle > 1) {
                        c.cameraStyle = 0;
                    }
                    c.afkFov = Math.max(30, Math.min(120, c.afkFov));
                    return c;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new Config();
        }
    }

    public record OrbitState(double radius, double yawRad, double pitchRad, double heightOffset) {
    }

    public static enum Anchor {
        CENTER,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        CUSTOM;

    }
}

