/*
 * Decompiled with CFR 0.152.
 */
package net.zynwro.afk.mixin;

import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.zynwro.afk.AfkCore;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_4184.class})
abstract class CameraMixin {
    @Unique
    private boolean afk_init;
    @Unique
    private double afk_px;
    @Unique
    private double afk_py;
    @Unique
    private double afk_pz;
    @Unique
    private float afk_yaw;
    @Unique
    private float afk_pitch;
    @Unique
    private double afk_vx;
    @Unique
    private double afk_vy;
    @Unique
    private double afk_vz;
    @Unique
    private float afk_vyaw;
    @Unique
    private float afk_vpitch;

    CameraMixin() {
    }

    @Shadow
    protected abstract void method_19327(double var1, double var3, double var5);

    @Shadow
    protected abstract void method_19325(float var1, float var2);

    @Unique
    private static float wrapYaw(float a, float target) {
        float d = (target - a) % 360.0f;
        if (d > 180.0f) {
            d -= 360.0f;
        }
        if (d < -180.0f) {
            d += 360.0f;
        }
        return a + d;
    }

    @Unique
    private static double damp(double current, double target, double[] v, double tau, double dt) {
        double omega = 2.0 / Math.max(1.0E-4, tau);
        double x = omega * dt;
        double exp = 1.0 / (1.0 + x + 0.48 * x * x + 0.235 * x * x * x);
        double change = current - target;
        double temp = (v[0] + omega * change) * dt;
        v[0] = (v[0] - omega * temp) * exp;
        return target + (change + temp) * exp;
    }

    @Unique
    private static float dampAngle(float current, float target, float[] v, double tau, double dt) {
        target = CameraMixin.wrapYaw(current, target);
        double[] box = new double[]{v[0]};
        double res = CameraMixin.damp(current, target, box, tau, dt);
        v[0] = (float)box[0];
        return (float)res;
    }

    @Inject(method={"method_19321(Lnet/minecraft/class_1922;Lnet/minecraft/class_1297;ZZF)V"}, at={@At(value="TAIL")})
    private void afk$applyCinematic(class_1922 area, class_1297 focusedEntity, boolean thirdPerson, boolean inverseView, float tickDelta, CallbackInfo ci) {
        if (!AfkCore.isCinematicActive() || focusedEntity == null) {
            this.afk_init = false;
            return;
        }
        AfkCore.OrbitState o = AfkCore.getOrbit();
        double cx = focusedEntity.method_23317();
        double cy = focusedEntity.method_23318() + (double)focusedEntity.method_5751() * 0.6 + o.heightOffset();
        double cz = focusedEntity.method_23321();
        double ox = o.radius() * Math.cos(o.yawRad()) * Math.cos(o.pitchRad());
        double oy = o.radius() * Math.sin(o.pitchRad());
        double oz = o.radius() * Math.sin(o.yawRad()) * Math.cos(o.pitchRad());
        double tx = cx + ox;
        double ty = cy + oy;
        double tz = cz + oz;
        double dx = cx - tx;
        double dy = cy - ty;
        double dz = cz - tz;
        double hz = Math.sqrt(dx * dx + dz * dz);
        float tyaw = (float)(class_3532.method_15349((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        float tpitch = (float)(-class_3532.method_15349((double)dy, (double)hz) * 57.29577951308232);
        double dt = Math.max(0.001, 0.016 + (double)tickDelta * 0.03);
        double tauPos = 0.55;
        double tauRot = 0.5;
        if (!this.afk_init) {
            this.afk_px = tx;
            this.afk_py = ty;
            this.afk_pz = tz;
            this.afk_yaw = tyaw;
            this.afk_pitch = tpitch;
            this.afk_vz = 0.0;
            this.afk_vy = 0.0;
            this.afk_vx = 0.0;
            this.afk_vpitch = 0.0f;
            this.afk_vyaw = 0.0f;
            this.afk_init = true;
        } else {
            double[] vx = new double[]{this.afk_vx};
            double[] vy = new double[]{this.afk_vy};
            double[] vz = new double[]{this.afk_vz};
            float[] vyaw = new float[]{this.afk_vyaw};
            double[] vpitch = new double[]{this.afk_vpitch};
            this.afk_px = CameraMixin.damp(this.afk_px, tx, vx, tauPos, dt);
            this.afk_vx = vx[0];
            this.afk_py = CameraMixin.damp(this.afk_py, ty, vy, tauPos, dt);
            this.afk_vy = vy[0];
            this.afk_pz = CameraMixin.damp(this.afk_pz, tz, vz, tauPos, dt);
            this.afk_vz = vz[0];
            this.afk_yaw = CameraMixin.dampAngle(this.afk_yaw, tyaw, vyaw, tauRot, dt);
            this.afk_vyaw = vyaw[0];
            this.afk_pitch = (float)CameraMixin.damp(this.afk_pitch, tpitch, vpitch, tauRot, dt);
            this.afk_vpitch = (float)vpitch[0];
        }
        this.method_19327(this.afk_px, this.afk_py, this.afk_pz);
        this.method_19325(this.afk_yaw, this.afk_pitch);
    }
}

