/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.choupsdrakvyrnmod.network;

import net.mcreator.choupsdrakvyrnmod.ChoupsDrakvyrnModMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ChoupsDrakvyrnModModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"choups_drakvyrn_mod");

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ChoupsDrakvyrnModMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"choups_drakvyrn_mod", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "choups_drakvyrn_mod_mapvars";
        public double MoveX = 0.0;
        public double MoveZ = 0.0;
        public double MoveY = 0.0;
        public boolean Pilotage = false;
        public boolean OnPlane = false;
        public double YAWAvion = 0.0;
        public double degrees = 0.0;
        public boolean Moteur = false;
        public double INERTIE = 0.0;
        public boolean sit = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.MoveX = nbt.getDouble("MoveX");
            this.MoveZ = nbt.getDouble("MoveZ");
            this.MoveY = nbt.getDouble("MoveY");
            this.Pilotage = nbt.getBoolean("Pilotage");
            this.OnPlane = nbt.getBoolean("OnPlane");
            this.YAWAvion = nbt.getDouble("YAWAvion");
            this.degrees = nbt.getDouble("degrees");
            this.Moteur = nbt.getBoolean("Moteur");
            this.INERTIE = nbt.getDouble("INERTIE");
            this.sit = nbt.getBoolean("sit");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("MoveX", this.MoveX);
            nbt.putDouble("MoveZ", this.MoveZ);
            nbt.putDouble("MoveY", this.MoveY);
            nbt.putBoolean("Pilotage", this.Pilotage);
            nbt.putBoolean("OnPlane", this.OnPlane);
            nbt.putDouble("YAWAvion", this.YAWAvion);
            nbt.putDouble("degrees", this.degrees);
            nbt.putBoolean("Moteur", this.Moteur);
            nbt.putDouble("INERTIE", this.INERTIE);
            nbt.putBoolean("sit", this.sit);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "choups_drakvyrn_mod_worldvars";
        public double DrakVyrnTimer = 0.0;
        public double GroundDrakvyrnAttack = 0.0;
        public double BlackDravyrnTimer = 0.0;
        public double SilverDravyrnTimer = 0.0;
        public double BronzeDravyrnTimer = 0.0;
        public double PurpleDravyrnTimer = 0.0;
        public double GreenDravyrnTimer = 0.0;
        public double WarpedDravyrnTimer = 0.0;
        public double CRimsonDravyrnTimer = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.DrakVyrnTimer = nbt.getDouble("DrakVyrnTimer");
            this.GroundDrakvyrnAttack = nbt.getDouble("GroundDrakvyrnAttack");
            this.BlackDravyrnTimer = nbt.getDouble("BlackDravyrnTimer");
            this.SilverDravyrnTimer = nbt.getDouble("SilverDravyrnTimer");
            this.BronzeDravyrnTimer = nbt.getDouble("BronzeDravyrnTimer");
            this.PurpleDravyrnTimer = nbt.getDouble("PurpleDravyrnTimer");
            this.GreenDravyrnTimer = nbt.getDouble("GreenDravyrnTimer");
            this.WarpedDravyrnTimer = nbt.getDouble("WarpedDravyrnTimer");
            this.CRimsonDravyrnTimer = nbt.getDouble("CRimsonDravyrnTimer");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("DrakVyrnTimer", this.DrakVyrnTimer);
            nbt.putDouble("GroundDrakvyrnAttack", this.GroundDrakvyrnAttack);
            nbt.putDouble("BlackDravyrnTimer", this.BlackDravyrnTimer);
            nbt.putDouble("SilverDravyrnTimer", this.SilverDravyrnTimer);
            nbt.putDouble("BronzeDravyrnTimer", this.BronzeDravyrnTimer);
            nbt.putDouble("PurpleDravyrnTimer", this.PurpleDravyrnTimer);
            nbt.putDouble("GreenDravyrnTimer", this.GreenDravyrnTimer);
            nbt.putDouble("WarpedDravyrnTimer", this.WarpedDravyrnTimer);
            nbt.putDouble("CRimsonDravyrnTimer", this.CRimsonDravyrnTimer);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

