/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.choupsdrakvyrnmod.network;

import java.util.function.Supplier;
import net.mcreator.choupsdrakvyrnmod.ChoupsDrakvyrnModMod;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ChoupsDrakvyrnModModVariables {
    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ChoupsDrakvyrnModMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "choups_drakvyrn_mod_mapvars";
        public double MoveX = 0.0;
        public double MoveZ = 0.0;
        public double MoveY = 0.0;
        public boolean Pilotage = false;
        public boolean OnPlane = false;
        public double YAWAvion = 0.0;
        public double degrees = 0.0;
        public boolean Moteur = false;
        public double INERTIE = 0.0;
        public boolean sit = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.MoveX = nbt.m_128459_("MoveX");
            this.MoveZ = nbt.m_128459_("MoveZ");
            this.MoveY = nbt.m_128459_("MoveY");
            this.Pilotage = nbt.m_128471_("Pilotage");
            this.OnPlane = nbt.m_128471_("OnPlane");
            this.YAWAvion = nbt.m_128459_("YAWAvion");
            this.degrees = nbt.m_128459_("degrees");
            this.Moteur = nbt.m_128471_("Moteur");
            this.INERTIE = nbt.m_128459_("INERTIE");
            this.sit = nbt.m_128471_("sit");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("MoveX", this.MoveX);
            nbt.m_128347_("MoveZ", this.MoveZ);
            nbt.m_128347_("MoveY", this.MoveY);
            nbt.m_128379_("Pilotage", this.Pilotage);
            nbt.m_128379_("OnPlane", this.OnPlane);
            nbt.m_128347_("YAWAvion", this.YAWAvion);
            nbt.m_128347_("degrees", this.degrees);
            nbt.m_128379_("Moteur", this.Moteur);
            nbt.m_128347_("INERTIE", this.INERTIE);
            nbt.m_128379_("sit", this.sit);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                ChoupsDrakvyrnModMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "choups_drakvyrn_mod_worldvars";
        public double DrakVyrnTimer = 0.0;
        public double GroundDrakvyrnAttack = 0.0;
        public double BlackDravyrnTimer = 0.0;
        public double SilverDravyrnTimer = 0.0;
        public double BronzeDravyrnTimer = 0.0;
        public double PurpleDravyrnTimer = 0.0;
        public double GreenDravyrnTimer = 0.0;
        public double WarpedDravyrnTimer = 0.0;
        public double CRimsonDravyrnTimer = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.DrakVyrnTimer = nbt.m_128459_("DrakVyrnTimer");
            this.GroundDrakvyrnAttack = nbt.m_128459_("GroundDrakvyrnAttack");
            this.BlackDravyrnTimer = nbt.m_128459_("BlackDravyrnTimer");
            this.SilverDravyrnTimer = nbt.m_128459_("SilverDravyrnTimer");
            this.BronzeDravyrnTimer = nbt.m_128459_("BronzeDravyrnTimer");
            this.PurpleDravyrnTimer = nbt.m_128459_("PurpleDravyrnTimer");
            this.GreenDravyrnTimer = nbt.m_128459_("GreenDravyrnTimer");
            this.WarpedDravyrnTimer = nbt.m_128459_("WarpedDravyrnTimer");
            this.CRimsonDravyrnTimer = nbt.m_128459_("CRimsonDravyrnTimer");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("DrakVyrnTimer", this.DrakVyrnTimer);
            nbt.m_128347_("GroundDrakvyrnAttack", this.GroundDrakvyrnAttack);
            nbt.m_128347_("BlackDravyrnTimer", this.BlackDravyrnTimer);
            nbt.m_128347_("SilverDravyrnTimer", this.SilverDravyrnTimer);
            nbt.m_128347_("BronzeDravyrnTimer", this.BronzeDravyrnTimer);
            nbt.m_128347_("PurpleDravyrnTimer", this.PurpleDravyrnTimer);
            nbt.m_128347_("GreenDravyrnTimer", this.GreenDravyrnTimer);
            nbt.m_128347_("WarpedDravyrnTimer", this.WarpedDravyrnTimer);
            nbt.m_128347_("CRimsonDravyrnTimer", this.CRimsonDravyrnTimer);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                ChoupsDrakvyrnModMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    ChoupsDrakvyrnModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    ChoupsDrakvyrnModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                ChoupsDrakvyrnModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

