/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.playingcards.block;

import com.ombremoon.playingcards.block.base.BlockBase;
import com.ombremoon.playingcards.entity.EntitySeat;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockBarStool
extends BlockBase {
    public static final IntegerProperty FACING = IntegerProperty.create((String)"facing", (int)0, (int)7);
    private static final VoxelShape AABB = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);

    public BlockBarStool() {
        super(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(1.0f).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Integer.valueOf(0)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        EntitySeat.createSeat(level, pos, player);
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        if (pContext.getPlayer() != null) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Integer.valueOf(Mth.floor((double)((double)((pContext.getPlayer().getYRot() + 180.0f) * 8.0f / 360.0f) + 0.5)) & 7));
        }
        return super.getStateForPlacement(pContext);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING});
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AABB;
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AABB;
    }

    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return true;
    }
}

