/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.playingcards.block;

import com.mojang.serialization.MapCodec;
import com.ombremoon.playingcards.block.base.BlockContainerBase;
import com.ombremoon.playingcards.init.InitTileEntityTypes;
import com.ombremoon.playingcards.tileentity.TileEntityPokerTable;
import com.ombremoon.playingcards.util.Location;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockPokerTable
extends BlockContainerBase {
    public static final MapCodec<BlockPokerTable> CODEC = BlockPokerTable.simpleCodec(BlockPokerTable::new);
    private static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    private static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    private static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    private static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    private static final BooleanProperty NORTHWEST = BooleanProperty.create((String)"northwest");
    private static final BooleanProperty NORTHEAST = BooleanProperty.create((String)"northeast");
    private static final BooleanProperty SOUTHWEST = BooleanProperty.create((String)"southwest");
    private static final BooleanProperty SOUTHEAST = BooleanProperty.create((String)"southeast");
    private static final VoxelShape AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public BlockPokerTable(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTHWEST, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTHEAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTHWEST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTHEAST, (Comparable)Boolean.valueOf(false)));
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        if (pPlacer instanceof Player) {
            Player player = (Player)pPlacer;
            Location location = new Location(pLevel, pPos);
            BlockEntity tileEntity = location.getTileEntity();
            if (tileEntity instanceof TileEntityPokerTable) {
                TileEntityPokerTable pokerTable = (TileEntityPokerTable)tileEntity;
                pokerTable.setOwner(player);
            }
        }
    }

    private boolean canConnectTo(LevelAccessor world, BlockPos pos, int offX, int offZ) {
        BlockPos otherPos = pos.offset(offX, 0, offZ);
        Block otherBlock = world.getBlockState(otherPos).getBlock();
        return otherBlock instanceof BlockPokerTable;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return this.getState((LevelAccessor)pContext.getLevel(), pContext.getClickedPos());
    }

    private BlockState getState(LevelAccessor world, BlockPos pos) {
        boolean north = this.canConnectTo(world, pos, 0, -1);
        boolean east = this.canConnectTo(world, pos, 1, 0);
        boolean south = this.canConnectTo(world, pos, 0, 1);
        boolean west = this.canConnectTo(world, pos, -1, 0);
        boolean northwest = this.canConnectTo(world, pos, -1, -1);
        boolean northeast = this.canConnectTo(world, pos, 1, -1);
        boolean southwest = this.canConnectTo(world, pos, -1, 1);
        boolean southeast = this.canConnectTo(world, pos, 1, 1);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west))).setValue((Property)NORTHWEST, (Comparable)Boolean.valueOf(northwest))).setValue((Property)NORTHEAST, (Comparable)Boolean.valueOf(northeast))).setValue((Property)SOUTHWEST, (Comparable)Boolean.valueOf(southwest))).setValue((Property)SOUTHEAST, (Comparable)Boolean.valueOf(southeast));
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        return this.getState(pLevel, pCurrentPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{NORTH, SOUTH, EAST, WEST, NORTHWEST, NORTHEAST, SOUTHWEST, SOUTHEAST});
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AABB;
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AABB;
    }

    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return true;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return InitTileEntityTypes.POKER_TABLE.get().create(blockPos, blockState);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

