/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.playingcards.entity;

import com.ombremoon.playingcards.entity.EntityCardDeck;
import com.ombremoon.playingcards.entity.base.EntityStacked;
import com.ombremoon.playingcards.init.InitDataComponents;
import com.ombremoon.playingcards.init.InitEntityTypes;
import com.ombremoon.playingcards.init.InitItems;
import com.ombremoon.playingcards.item.ItemCardCovered;
import com.ombremoon.playingcards.util.ChatHelper;
import com.ombremoon.playingcards.util.ItemHelper;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityCard
extends EntityStacked {
    private static final EntityDataAccessor<Float> ROTATION = SynchedEntityData.defineId(EntityCard.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Byte> SKIN_ID = SynchedEntityData.defineId(EntityCard.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Optional<UUID>> DECK_UUID = SynchedEntityData.defineId(EntityCard.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Boolean> COVERED = SynchedEntityData.defineId(EntityCard.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public EntityCard(EntityType<? extends EntityCard> type, Level world) {
        super(type, world);
    }

    public EntityCard(Level world, Vec3 position, float rotation, byte skinID, UUID deckUUID, boolean covered, byte firstCardID) {
        super(InitEntityTypes.CARD.get(), world, position);
        this.createStack();
        this.addToTop(firstCardID);
        this.entityData.set(ROTATION, (Object)Float.valueOf(rotation));
        this.entityData.set(SKIN_ID, (Object)skinID);
        this.entityData.set(DECK_UUID, Optional.of(deckUUID));
        this.entityData.set(COVERED, (Object)covered);
    }

    public float getRotation() {
        return ((Float)this.entityData.get(ROTATION)).floatValue();
    }

    public byte getSkinID() {
        return (Byte)this.entityData.get(SKIN_ID);
    }

    public UUID getDeckUUID() {
        return ((Optional)this.entityData.get(DECK_UUID)).isPresent() ? (UUID)((Optional)this.entityData.get(DECK_UUID)).get() : null;
    }

    public boolean isCover() {
        return (Boolean)this.entityData.get(COVERED);
    }

    private void takeCard(Player player) {
        ItemStack card = new ItemStack((ItemLike)InitItems.CARD.get());
        if (((Boolean)this.entityData.get(COVERED)).booleanValue()) {
            card = new ItemStack((ItemLike)InitItems.CARD_COVERED.get());
        }
        card.set(InitDataComponents.VALUE, (Object)this.getTopStackID());
        card.set(InitDataComponents.DECK_ID, (Object)this.getDeckUUID());
        card.set(InitDataComponents.SKIN_ID, (Object)((Byte)this.entityData.get(SKIN_ID)));
        card.set(InitDataComponents.COVERED, (Object)((Boolean)this.entityData.get(COVERED)));
        if (!this.level().isClientSide) {
            ItemHelper.spawnStackAtEntity(this.level(), (Entity)player, card);
        }
        this.removeFromTop();
        if (this.getStackAmount() <= 0) {
            this.discard();
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().getGameTime() % 20L == 0L) {
            BlockPos pos = this.blockPosition();
            List closeDecks = this.level().getEntitiesOfClass(EntityCardDeck.class, new AABB((double)(pos.getX() - 20), (double)(pos.getY() - 20), (double)(pos.getZ() - 20), (double)(pos.getX() + 20), (double)(pos.getY() + 20), (double)(pos.getZ() + 20)));
            boolean foundParentDeck = false;
            for (EntityCardDeck closeDeck : closeDecks) {
                if (!this.getDeckUUID().equals(closeDeck.getUUID())) continue;
                foundParentDeck = true;
            }
            if (!foundParentDeck) {
                this.discard();
            }
            super.onRemovedFromLevel();
        }
    }

    public InteractionResult interact(Player pPlayer, InteractionHand pHand) {
        ItemStack stack = pPlayer.getItemInHand(pHand);
        if (stack.getItem() instanceof ItemCardCovered) {
            if (this.getStackAmount() < 52) {
                this.addToTop((Byte)stack.get(InitDataComponents.VALUE));
                stack.shrink(1);
            } else if (this.level().isClientSide) {
                ChatHelper.printModMessage(ChatFormatting.RED, Component.translatable((String)"message.stack_full"), new Entity[]{pPlayer});
            }
        } else {
            this.takeCard(pPlayer);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean hurt(DamageSource source, float amount) {
        this.entityData.set(COVERED, (Object)((Boolean)this.entityData.get(COVERED) == false ? 1 : 0));
        return true;
    }

    @Override
    public void moreData(SynchedEntityData.Builder builder) {
        builder.define(ROTATION, (Object)Float.valueOf(0.0f));
        builder.define(SKIN_ID, (Object)0);
        builder.define(DECK_UUID, Optional.empty());
        builder.define(COVERED, (Object)false);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.entityData.set(ROTATION, (Object)Float.valueOf(compoundTag.getFloat("Rotation")));
        this.entityData.set(SKIN_ID, (Object)compoundTag.getByte("SkinID"));
        this.entityData.set(DECK_UUID, Optional.of(compoundTag.getUUID("DeckID")));
        this.entityData.set(COVERED, (Object)compoundTag.getBoolean("Covered"));
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putFloat("Rotation", ((Float)this.entityData.get(ROTATION)).floatValue());
        compoundTag.putByte("SkinID", ((Byte)this.entityData.get(SKIN_ID)).byteValue());
        compoundTag.putUUID("DeckID", this.getDeckUUID());
        compoundTag.putBoolean("Covered", ((Boolean)this.entityData.get(COVERED)).booleanValue());
    }
}

