/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.playingcards.entity;

import com.ombremoon.playingcards.entity.base.EntityStacked;
import com.ombremoon.playingcards.init.InitDataComponents;
import com.ombremoon.playingcards.init.InitEntityTypes;
import com.ombremoon.playingcards.init.InitItems;
import com.ombremoon.playingcards.util.ChatHelper;
import com.ombremoon.playingcards.util.ItemHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityCardDeck
extends EntityStacked {
    private static final EntityDataAccessor<Float> ROTATION = SynchedEntityData.defineId(EntityCardDeck.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Byte> SKIN_ID = SynchedEntityData.defineId(EntityCardDeck.class, (EntityDataSerializer)EntityDataSerializers.BYTE);

    public EntityCardDeck(EntityType<? extends EntityCardDeck> type, Level world) {
        super(type, world);
    }

    public EntityCardDeck(Level world, Vec3 position, float rotation, byte skinID) {
        super(InitEntityTypes.CARD_DECK.get(), world, position);
        this.createAndFillDeck();
        this.shuffleStack();
        this.entityData.set(ROTATION, (Object)Float.valueOf(rotation));
        this.entityData.set(SKIN_ID, (Object)skinID);
    }

    public float getRotation() {
        return ((Float)this.entityData.get(ROTATION)).floatValue();
    }

    public byte getSkinID() {
        return (Byte)this.entityData.get(SKIN_ID);
    }

    private void createAndFillDeck() {
        Byte[] newStack = new Byte[52];
        for (byte index = 0; index < 52; index = (byte)(index + 1)) {
            newStack[index] = index;
        }
        this.entityData.set(STACK, (Object)newStack);
    }

    public InteractionResult interact(Player pPlayer, InteractionHand pHand) {
        if (pHand == InteractionHand.MAIN_HAND) {
            if (this.getStackAmount() > 0) {
                byte cardID = this.getTopStackID();
                ItemStack card = new ItemStack((ItemLike)InitItems.CARD_COVERED.get());
                card.set(InitDataComponents.VALUE, (Object)cardID);
                card.set(InitDataComponents.DECK_ID, (Object)this.getUUID());
                card.set(InitDataComponents.SKIN_ID, (Object)((Byte)this.entityData.get(SKIN_ID)));
                card.set(InitDataComponents.COVERED, (Object)true);
                if (!this.level().isClientSide) {
                    ItemHelper.spawnStackAtEntity(this.level(), (Entity)pPlayer, card);
                }
                this.removeFromTop();
                return pPlayer.getMainHandItem().isEmpty() ? InteractionResult.SUCCESS : InteractionResult.FAIL;
            }
            if (this.level().isClientSide) {
                ChatHelper.printModMessage(ChatFormatting.RED, Component.translatable((String)"message.stack_empty"), new Entity[]{pPlayer});
            }
        }
        return InteractionResult.FAIL;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        Entity entity = pSource.getDirectEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.isCrouching()) {
                ItemStack deck = new ItemStack((ItemLike)InitItems.CARD_DECK.get());
                deck.set(InitDataComponents.SKIN_ID, (Object)((Byte)this.entityData.get(SKIN_ID)));
                ItemHelper.spawnStackAtEntity(this.level(), (Entity)player, deck);
                this.discard();
            } else {
                this.shuffleStack();
                if (this.level().isClientSide) {
                    ChatHelper.printModMessage(ChatFormatting.GREEN, Component.translatable((String)"message.stack_shuffled"), new Entity[]{player});
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void moreData(SynchedEntityData.Builder builder) {
        builder.define(ROTATION, (Object)Float.valueOf(0.0f));
        builder.define(SKIN_ID, (Object)0);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.entityData.set(ROTATION, (Object)Float.valueOf(compoundTag.getFloat("Rotation")));
        this.entityData.set(SKIN_ID, (Object)compoundTag.getByte("SkinID"));
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putFloat("Rotation", ((Float)this.entityData.get(ROTATION)).floatValue());
        compoundTag.putByte("SkinID", ((Byte)this.entityData.get(SKIN_ID)).byteValue());
    }
}

