/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.playingcards.entity;

import com.ombremoon.playingcards.init.InitEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityDice
extends Entity {
    public EntityDice(EntityType<? extends EntityDice> type, Level world) {
        super(type, world);
    }

    public EntityDice(Level world, Vec3 position, float rotation) {
        this(InitEntityTypes.DICE.get(), world);
        this.setPos(position.x, position.y, position.z);
        this.setRot(rotation, 0.0f);
        float sin = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180) - 11.0f));
        float cos = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180) - 11.0f));
        this.setDeltaMovement(0.5 * (double)cos, 0.2, 0.5 * (double)sin);
    }

    public void tick() {
        double d0;
        super.tick();
        this.xo = this.blockPosition().getX();
        this.yo = this.blockPosition().getY();
        this.zo = this.blockPosition().getZ();
        Vec3 motion = this.getDeltaMovement();
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        if (this.level().isClientSide) {
            this.noPhysics = false;
        }
        if (!this.onGround() || (this.tickCount + this.getId()) % 4 == 0) {
            this.move(MoverType.SELF, this.getDeltaMovement());
            float f = 0.98f;
            if (this.onGround()) {
                BlockPos pos = new BlockPos(this.blockPosition().getX(), (int)((double)this.blockPosition().getY() - 1.0), this.blockPosition().getZ());
                f = this.level().getBlockState(pos).getFriction((LevelReader)this.level(), pos, (Entity)this) * 0.98f;
            }
            this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, 0.98, (double)f));
            if (this.onGround()) {
                this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -0.5, 1.0));
            }
        }
        if (!this.level().isClientSide && (d0 = this.getDeltaMovement().subtract(motion).lengthSqr()) > 0.01) {
            this.hasImpulse = true;
        }
    }

    @Nullable
    public Component getCustomName() {
        return Component.literal((String)"6");
    }

    public boolean shouldShowName() {
        return true;
    }

    public boolean isCustomNameVisible() {
        return true;
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }
}

