/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.playingcards.entity;

import com.ombremoon.playingcards.entity.base.EntityStacked;
import com.ombremoon.playingcards.init.InitDataComponents;
import com.ombremoon.playingcards.init.InitEntityTypes;
import com.ombremoon.playingcards.init.InitItems;
import com.ombremoon.playingcards.item.ItemPokerChip;
import com.ombremoon.playingcards.util.ChatHelper;
import com.ombremoon.playingcards.util.ItemHelper;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityPokerChip
extends EntityStacked {
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(EntityPokerChip.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<String> OWNER_NAME = SynchedEntityData.defineId(EntityPokerChip.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public EntityPokerChip(EntityType<? extends EntityPokerChip> type, Level world) {
        super(type, world);
    }

    public EntityPokerChip(Level world, Vec3 position, UUID ownerID, String ownerName, byte firstChipID) {
        super(InitEntityTypes.POKER_CHIP.get(), world, position);
        this.createStack();
        this.addToTop(firstChipID);
        this.entityData.set(OWNER_UUID, Optional.of(ownerID));
        this.entityData.set(OWNER_NAME, (Object)ownerName);
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(OWNER_UUID)).isPresent() ? (UUID)((Optional)this.entityData.get(OWNER_UUID)).get() : null;
    }

    private void takeChip(Player player) {
        byte chipID = this.getTopStackID();
        if (!this.level().isClientSide) {
            this.spawnChip(player, ItemPokerChip.getPokerChip(chipID), 1);
        }
        this.removeFromTop();
        if (this.getStackAmount() <= 0) {
            this.discard();
        }
    }

    public InteractionResult interact(Player pPlayer, InteractionHand pHand) {
        ItemStack stack = pPlayer.getItemInHand(pHand);
        if (stack.getItem() instanceof ItemPokerChip) {
            UUID ownerID = (UUID)stack.get(InitDataComponents.OWNER_ID);
            if (ownerID != null) {
                if (ownerID.equals(this.getOwnerUUID())) {
                    if (pPlayer.isCrouching()) {
                        while (this.getStackAmount() < 52 && stack.getCount() > 0) {
                            ItemPokerChip chip = (ItemPokerChip)stack.getItem();
                            this.addToTop(chip.getChipID());
                            stack.shrink(1);
                        }
                    } else if (this.getStackAmount() < 52) {
                        ItemPokerChip chip = (ItemPokerChip)stack.getItem();
                        this.addToTop(chip.getChipID());
                        stack.shrink(1);
                    } else if (this.level().isClientSide) {
                        ChatHelper.printModMessage(ChatFormatting.RED, Component.translatable((String)"message.stack_full"), new Entity[]{pPlayer});
                    }
                } else if (this.level().isClientSide) {
                    ChatHelper.printModMessage(ChatFormatting.RED, Component.translatable((String)"message.stack_owner_error"), new Entity[]{pPlayer});
                }
            }
        } else {
            this.takeChip(pPlayer);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        Entity entity = pSource.getDirectEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int whiteAmount = 0;
            int redAmount = 0;
            int blueAmount = 0;
            int greenAmount = 0;
            int blackAmount = 0;
            for (int i = 0; i < ((Byte[])this.entityData.get(STACK)).length; ++i) {
                byte chipID = this.getIDAt(i);
                if (chipID == 0) {
                    ++whiteAmount;
                }
                if (chipID == 1) {
                    ++redAmount;
                }
                if (chipID == 2) {
                    ++blueAmount;
                }
                if (chipID == 3) {
                    ++greenAmount;
                }
                if (chipID != 4) continue;
                ++blackAmount;
            }
            if (whiteAmount > 0) {
                this.spawnChip(player, InitItems.POKER_CHIP_WHITE.get(), whiteAmount);
            }
            if (redAmount > 0) {
                this.spawnChip(player, InitItems.POKER_CHIP_RED.get(), redAmount);
            }
            if (blueAmount > 0) {
                this.spawnChip(player, InitItems.POKER_CHIP_BLUE.get(), blueAmount);
            }
            if (greenAmount > 0) {
                this.spawnChip(player, InitItems.POKER_CHIP_GREEN.get(), greenAmount);
            }
            if (blackAmount > 0) {
                this.spawnChip(player, InitItems.POKER_CHIP_BLACK.get(), blackAmount);
            }
            this.discard();
            return false;
        }
        return true;
    }

    private void spawnChip(Player player, Item item, int amount) {
        if (!this.level().isClientSide) {
            ItemStack chip = new ItemStack((ItemLike)item, amount);
            chip.set(InitDataComponents.OWNER_ID, (Object)this.getOwnerUUID());
            chip.set(InitDataComponents.OWNER_NAME, (Object)((String)this.entityData.get(OWNER_NAME)));
            ItemHelper.spawnStackAtEntity(this.level(), (Entity)player, chip);
        }
    }

    @Override
    public void tick() {
        super.tick();
        Vec3 pos = this.position();
        double size = 0.1;
        double addAmount = 0.01575;
        this.setBoundingBox(new AABB(pos.x - size, pos.y, pos.z - size, pos.x + size, pos.y + 0.02 + addAmount * (double)this.getStackAmount(), pos.z + size));
    }

    @Override
    public void moreData(SynchedEntityData.Builder builder) {
        builder.define(OWNER_UUID, Optional.empty());
        builder.define(OWNER_NAME, (Object)"");
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.entityData.set(OWNER_UUID, Optional.of(compoundTag.getUUID("OwnerID")));
        this.entityData.set(OWNER_NAME, (Object)compoundTag.getString("OwnerName"));
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putUUID("OwnerID", this.getOwnerUUID());
        compoundTag.putString("OwnerName", (String)this.entityData.get(OWNER_NAME));
    }
}

