/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.playingcards.entity;

import com.ombremoon.playingcards.init.InitEntityTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntitySeat
extends Entity {
    private BlockPos sourceBlock;

    public EntitySeat(EntityType<? extends EntitySeat> type, Level world) {
        super(type, world);
    }

    public EntitySeat(Level world, BlockPos sourceBlock) {
        this(InitEntityTypes.SEAT.get(), world);
        this.sourceBlock = sourceBlock;
        this.setPos((float)sourceBlock.getX() + 0.5f, (float)sourceBlock.getY() + 0.3f, (float)sourceBlock.getZ() + 0.5f);
    }

    private BlockPos getSourceBlock() {
        return this.sourceBlock;
    }

    public static void createSeat(Level world, BlockPos pos, Player player) {
        List seats;
        if (!world.isClientSide && (seats = world.getEntitiesOfClass(EntitySeat.class, new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1)))).isEmpty()) {
            EntitySeat seat = new EntitySeat(world, pos);
            world.addFreshEntity((Entity)seat);
            player.startRiding((Entity)seat);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (this.sourceBlock == null) {
            this.sourceBlock = this.blockPosition();
        }
        if (!this.level().isClientSide && (this.getPassengers().isEmpty() || this.level().getBlockState(this.sourceBlock).isAir())) {
            this.discard();
        }
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        return super.getPassengerAttachmentPoint(entity, dimensions, partialTick).add(0.0, 0.175, 0.0);
    }
}

