/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.playingcards.entity.base;

import com.ombremoon.playingcards.init.InitEntityDataSerializers;
import com.ombremoon.playingcards.util.ArrayHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class EntityStacked
extends Entity {
    public static final byte MAX_STACK_SIZE = 52;
    protected static final EntityDataAccessor<Byte[]> STACK = SynchedEntityData.defineId(EntityStacked.class, InitEntityDataSerializers.STACK.get());

    public EntityStacked(EntityType<? extends EntityStacked> type, Level world) {
        super(type, world);
    }

    public EntityStacked(EntityType<? extends EntityStacked> type, Level world, Vec3 position) {
        this(type, world);
        this.setPos(position.x, position.y, position.z);
        this.setRot(0.0f, 0.0f);
    }

    public int getStackAmount() {
        return ((Byte[])this.entityData.get(STACK)).length;
    }

    public byte getTopStackID() {
        return this.getIDAt(this.getStackAmount() - 1);
    }

    public byte getIDAt(int index) {
        if (index >= 0 && index < this.getStackAmount()) {
            return ((Byte[])this.entityData.get(STACK))[index];
        }
        return 0;
    }

    public void removeFromTop() {
        Byte[] newStack = new Byte[this.getStackAmount() - 1];
        for (int index = 0; index < newStack.length; ++index) {
            newStack[index] = ((Byte[])this.entityData.get(STACK))[index];
        }
        this.entityData.set(STACK, (Object)newStack);
    }

    public void addToTop(byte id) {
        Byte[] newStack = new Byte[this.getStackAmount() + 1];
        for (int index = 0; index < this.getStackAmount(); ++index) {
            newStack[index] = ((Byte[])this.entityData.get(STACK))[index];
        }
        newStack[newStack.length - 1] = id;
        this.entityData.set(STACK, (Object)newStack);
    }

    public void createStack() {
        Byte[] newStack = new Byte[]{};
        this.entityData.set(STACK, (Object)newStack);
    }

    public void shuffleStack() {
        Object[] newStack = new Byte[this.getStackAmount()];
        for (int index = 0; index < this.getStackAmount(); ++index) {
            newStack[index] = ((Byte[])this.entityData.get(STACK))[index];
        }
        ArrayHelper.shuffle(newStack);
        this.entityData.set(STACK, (Object)newStack);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.noPhysics = false;
        } else {
            boolean bl = this.noPhysics = !this.level().noCollision((Entity)this);
            if (this.noPhysics) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.02, 0.0));
            } else {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
            }
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        Vec3 pos = this.position();
        double size = 0.2;
        double addAmount = 0.0045;
        this.setBoundingBox(new AABB(pos.x - size, pos.y, pos.z - size, pos.x + size, pos.y + 0.03 + addAmount * (double)this.getStackAmount(), pos.z + size));
    }

    public abstract void moreData(SynchedEntityData.Builder var1);

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(STACK, (Object)new Byte[0]);
        this.moreData(builder);
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        this.entityData.set(STACK, (Object)ArrayHelper.toObject(compoundTag.getByteArray("Stack")));
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putByteArray("Stack", ArrayHelper.toPrimitive((Byte[])this.entityData.get(STACK)));
    }

    public boolean isPickable() {
        return true;
    }
}

