/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.playingcards.item;

import com.ombremoon.playingcards.entity.EntityCard;
import com.ombremoon.playingcards.entity.EntityCardDeck;
import com.ombremoon.playingcards.init.InitDataComponents;
import com.ombremoon.playingcards.init.InitItems;
import com.ombremoon.playingcards.item.base.ItemBase;
import com.ombremoon.playingcards.util.CardHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ItemCardCovered
extends ItemBase {
    public ItemCardCovered() {
        super(new Item.Properties().stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        Byte skinID = (Byte)stack.get(InitDataComponents.SKIN_ID);
        tooltipComponents.add((Component)Component.translatable((String)"lore.cover").append(" ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)CardHelper.CARD_SKIN_NAMES[skinID != null ? skinID : (byte)0]).withStyle(ChatFormatting.AQUA)));
    }

    public void flipCard(ItemStack heldItem, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (heldItem.getItem() instanceof ItemCardCovered) {
                Item nextCard = InitItems.CARD.get();
                boolean covered = true;
                if (heldItem.get(InitDataComponents.COVERED) != null) {
                    covered = (Boolean)heldItem.get(InitDataComponents.COVERED);
                }
                if (!covered) {
                    nextCard = InitItems.CARD_COVERED.get();
                }
                ItemStack newCard = new ItemStack((ItemLike)nextCard);
                newCard.set(InitDataComponents.VALUE, (Object)((Byte)heldItem.get(InitDataComponents.VALUE)));
                newCard.set(InitDataComponents.DECK_ID, (Object)((UUID)heldItem.get(InitDataComponents.DECK_ID)));
                newCard.set(InitDataComponents.SKIN_ID, (Object)((Byte)heldItem.get(InitDataComponents.SKIN_ID)));
                newCard.set(InitDataComponents.COVERED, (Object)(!covered ? 1 : 0));
                player.setItemInHand(InteractionHand.MAIN_HAND, newCard);
            }
        }
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pLevel.getGameTime() % 60L == 0L && pEntity instanceof Player) {
            Player player = (Player)pEntity;
            BlockPos pos = player.blockPosition();
            UUID id = (UUID)pStack.get(InitDataComponents.DECK_ID);
            if (id != null) {
                if (id.getLeastSignificantBits() == 0L) {
                    return;
                }
                List closeDecks = pLevel.getEntitiesOfClass(EntityCardDeck.class, new AABB((double)(pos.getX() - 20), (double)(pos.getY() - 20), (double)(pos.getZ() - 20), (double)(pos.getX() + 20), (double)(pos.getY() + 20), (double)(pos.getZ() + 20)));
                boolean found = false;
                for (EntityCardDeck closeDeck : closeDecks) {
                    if (!closeDeck.getUUID().equals(id)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    player.getInventory().getItem(pSlotId).shrink(1);
                }
            }
        }
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Player player = pContext.getPlayer();
        if (player != null && !player.isCrouching()) {
            BlockPos pos = pContext.getClickedPos();
            List closeDecks = pContext.getLevel().getEntitiesOfClass(EntityCardDeck.class, new AABB((double)(pos.getX() - 8), (double)(pos.getY() - 8), (double)(pos.getZ() - 8), (double)(pos.getX() + 8), (double)(pos.getY() + 8), (double)(pos.getZ() + 8)));
            ItemStack stack = pContext.getItemInHand();
            UUID deckID = (UUID)stack.get(InitDataComponents.DECK_ID);
            if (deckID != null) {
                for (EntityCardDeck closeDeck : closeDecks) {
                    if (!closeDeck.getUUID().equals(deckID)) continue;
                    Level world = pContext.getLevel();
                    Byte skinID = (Byte)stack.get(InitDataComponents.SKIN_ID);
                    Boolean covered = (Boolean)stack.get(InitDataComponents.COVERED);
                    EntityCard cardDeck = new EntityCard(world, pContext.getClickLocation(), pContext.getRotation(), skinID != null ? skinID : (byte)0, deckID, covered != null ? covered : true, (Byte)pContext.getItemInHand().get(InitDataComponents.VALUE));
                    world.addFreshEntity((Entity)cardDeck);
                    pContext.getItemInHand().shrink(1);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }
}

