/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.playingcards.item;

import com.ombremoon.playingcards.entity.EntityCardDeck;
import com.ombremoon.playingcards.init.InitDataComponents;
import com.ombremoon.playingcards.item.base.ItemBase;
import com.ombremoon.playingcards.util.CardHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemCardDeck
extends ItemBase {
    public ItemCardDeck() {
        super(new Item.Properties().stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        Byte skinID = (Byte)stack.get(InitDataComponents.SKIN_ID);
        tooltipComponents.add((Component)Component.translatable((String)"lore.cover").append(" ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)CardHelper.CARD_SKIN_NAMES[skinID != null ? skinID : (byte)0]).withStyle(ChatFormatting.AQUA)));
    }

    public void fillItemGroup(CreativeModeTab.Output output) {
        for (byte colorID = 0; colorID < CardHelper.CARD_SKIN_NAMES.length; colorID = (byte)(colorID + 1)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            stack.set(InitDataComponents.SKIN_ID, (Object)colorID);
            output.accept(stack);
        }
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Level world = pContext.getLevel();
        if (!world.isClientSide) {
            Byte skinID = (Byte)pContext.getItemInHand().get(InitDataComponents.SKIN_ID);
            EntityCardDeck cardDeck = new EntityCardDeck(world, pContext.getClickLocation(), pContext.getRotation(), skinID != null ? skinID : (byte)0);
            world.addFreshEntity((Entity)cardDeck);
            pContext.getItemInHand().shrink(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }
}

