/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.playingcards.item;

import com.ombremoon.playingcards.entity.EntityPokerChip;
import com.ombremoon.playingcards.init.InitDataComponents;
import com.ombremoon.playingcards.init.InitItems;
import com.ombremoon.playingcards.item.base.ItemBase;
import com.ombremoon.playingcards.tileentity.TileEntityPokerTable;
import com.ombremoon.playingcards.util.Location;
import com.ombremoon.playingcards.util.StringHelper;
import com.ombremoon.playingcards.util.UnitChatMessage;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ItemPokerChip
extends ItemBase {
    private final byte chipID;
    private final int value;

    public ItemPokerChip(byte chipID, int value) {
        super(new Item.Properties());
        this.chipID = chipID;
        this.value = value;
    }

    private UnitChatMessage getUnitMessage(Player ... players) {
        return new UnitChatMessage("poker_chip", (Entity[])players);
    }

    public byte getChipID() {
        return this.chipID;
    }

    public static Item getPokerChip(byte pokerChipID) {
        switch (pokerChipID) {
            case 1: {
                return InitItems.POKER_CHIP_RED.get();
            }
            case 2: {
                return InitItems.POKER_CHIP_BLUE.get();
            }
            case 3: {
                return InitItems.POKER_CHIP_GREEN.get();
            }
            case 4: {
                return InitItems.POKER_CHIP_BLACK.get();
            }
        }
        return InitItems.POKER_CHIP_WHITE.get();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        UUID ownerID = (UUID)stack.get(InitDataComponents.OWNER_ID);
        if (ownerID != null) {
            tooltipComponents.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Owner: " + String.valueOf(ChatFormatting.GOLD) + (String)stack.get(InitDataComponents.OWNER_NAME))));
        } else {
            tooltipComponents.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Owner: " + String.valueOf(ChatFormatting.GOLD) + "Not set")));
        }
        tooltipComponents.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Value (1): " + String.valueOf(ChatFormatting.GOLD) + this.value)));
        if (stack.getCount() > 1) {
            tooltipComponents.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Value (" + stack.getCount() + "): " + String.valueOf(ChatFormatting.GOLD) + StringHelper.printCommas(this.value * stack.getCount()))));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack heldItem = pPlayer.getItemInHand(pUsedHand);
        if (pPlayer.isCrouching()) {
            UnitChatMessage unitMessage = this.getUnitMessage(pPlayer);
            UUID ownerID = (UUID)heldItem.get(InitDataComponents.OWNER_ID);
            if (ownerID == null) {
                heldItem.set(InitDataComponents.OWNER_ID, (Object)pPlayer.getUUID());
                heldItem.set(InitDataComponents.OWNER_NAME, (Object)pPlayer.getDisplayName().getString());
                if (pLevel.isClientSide) {
                    unitMessage.printMessage(ChatFormatting.GREEN, Component.translatable((String)"message.poker_chip_owner_set"));
                }
            } else if (pLevel.isClientSide) {
                unitMessage.printMessage(ChatFormatting.RED, Component.translatable((String)"message.poker_chip_owner_error"));
            }
            return InteractionResultHolder.success((Object)heldItem);
        }
        return InteractionResultHolder.fail((Object)heldItem);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Player player = pContext.getPlayer();
        if (player != null && !player.isCrouching()) {
            Level world = pContext.getLevel();
            ItemStack stack = pContext.getItemInHand();
            Location location = new Location(world, pContext.getClickedPos());
            UnitChatMessage unitMessage = this.getUnitMessage(player);
            UUID ownerID = (UUID)stack.get(InitDataComponents.OWNER_ID);
            if (ownerID != null) {
                TileEntityPokerTable pokerTable;
                BlockEntity tileEntity;
                String ownerName = (String)stack.get(InitDataComponents.OWNER_NAME);
                if (location.getBlockState().hasBlockEntity() && (tileEntity = location.getTileEntity()) instanceof TileEntityPokerTable && !ownerID.equals((pokerTable = (TileEntityPokerTable)tileEntity).getOwnerID())) {
                    if (world.isClientSide) {
                        unitMessage.printMessage(ChatFormatting.RED, Component.translatable((String)"message.poker_chip_table_error"));
                    }
                    return InteractionResult.PASS;
                }
                EntityPokerChip chip = new EntityPokerChip(world, pContext.getClickLocation(), ownerID, ownerName, this.chipID);
                world.addFreshEntity((Entity)chip);
                pContext.getItemInHand().shrink(1);
            } else if (world.isClientSide) {
                unitMessage.printMessage(ChatFormatting.RED, Component.translatable((String)"message.poker_chip_owner_missing"));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

