/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.playingcards.recipes;

import com.ombremoon.playingcards.init.InitDataComponents;
import com.ombremoon.playingcards.init.InitItems;
import com.ombremoon.playingcards.init.InitRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CardDeckRecipe
extends CustomRecipe {
    public CardDeckRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        if (craftingInput.width() == 3 && craftingInput.height() == 3) {
            boolean matches = true;
            for (int i = 0; i < craftingInput.size(); ++i) {
                ItemStack stackInSlot = craftingInput.getItem(i);
                if (i == 4 || stackInSlot.getItem() == Items.PAPER) continue;
                matches = false;
            }
            ItemStack middleSlot = craftingInput.getItem(4);
            if (middleSlot.getItem() != Items.BLUE_DYE && middleSlot.getItem() != Items.RED_DYE && middleSlot.getItem() != Items.BLACK_DYE && middleSlot.getItem() != Items.PINK_DYE) {
                matches = false;
            }
            return matches;
        }
        return false;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        ItemStack result = new ItemStack((ItemLike)InitItems.CARD_DECK.get());
        ItemStack middleSlot = craftingInput.getItem(4);
        if (middleSlot.getItem() == Items.RED_DYE) {
            result.set(InitDataComponents.SKIN_ID, (Object)1);
        } else if (middleSlot.getItem() == Items.BLACK_DYE) {
            result.set(InitDataComponents.SKIN_ID, (Object)2);
        } else if (middleSlot.getItem() == Items.PINK_DYE) {
            result.set(InitDataComponents.SKIN_ID, (Object)3);
        }
        return result;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth >= 3 && pHeight >= 3;
    }

    public RecipeSerializer<?> getSerializer() {
        return InitRecipes.DECK.get();
    }
}

