/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.playingcards.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.ombremoon.playingcards.entity.EntityCard;
import com.ombremoon.playingcards.init.InitDataComponents;
import com.ombremoon.playingcards.init.InitItems;
import com.ombremoon.playingcards.util.CardHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RenderEntityCard
extends EntityRenderer<EntityCard> {
    public RenderEntityCard(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(EntityCard pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.render((Entity)pEntity, pEntityYaw, pPartialTick, pPoseStack, pBuffer, pPackedLight);
        ItemStack card = new ItemStack((ItemLike)InitItems.CARD.get());
        card.set(InitDataComponents.VALUE, (Object)pEntity.getTopStackID());
        if (pEntity.isCover()) {
            card = new ItemStack((ItemLike)InitItems.CARD_COVERED.get());
            card.set(InitDataComponents.SKIN_ID, (Object)pEntity.getSkinID());
        }
        pPoseStack.pushPose();
        pPoseStack.mulPose(Axis.YP.rotationDegrees(-pEntity.getRotation() + 180.0f));
        pPoseStack.scale(1.5f, 1.5f, 1.5f);
        for (int i = 0; i < pEntity.getStackAmount(); i = (int)((byte)(i + 1))) {
            CardHelper.renderItem(card, pEntity.level(), 0.0, (double)i * 0.003, 0.0, pPoseStack, pBuffer, pPackedLight);
        }
        pPoseStack.popPose();
    }

    public ResourceLocation getTextureLocation(EntityCard pEntity) {
        return null;
    }
}

