/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.playingcards.tileentity;

import com.ombremoon.playingcards.init.InitTileEntityTypes;
import com.ombremoon.playingcards.tileentity.base.TileEntityBase;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityPokerTable
extends TileEntityBase {
    private UUID ownerID;
    private String ownerName;

    public TileEntityPokerTable(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public TileEntityPokerTable(BlockPos pPos, BlockState pBlockState) {
        super(InitTileEntityTypes.POKER_TABLE.get(), pPos, pBlockState);
    }

    public void setOwner(Player player) {
        this.ownerID = player.getUUID();
        this.ownerName = player.getDisplayName().getString();
    }

    public UUID getOwnerID() {
        return this.ownerID;
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider lookupProvidier) {
        this.ownerID = pTag.getUUID("OwnerID");
        this.ownerName = pTag.getString("OwnerName");
        super.loadAdditional(pTag, lookupProvidier);
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider lookupProvidier) {
        nbt.putUUID("OwnerID", this.ownerID);
        nbt.putString("OwnerName", this.ownerName);
        super.saveAdditional(nbt, lookupProvidier);
    }
}

