/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.playingcards.tileentity.base;

import com.ombremoon.playingcards.util.Location;
import com.ombremoon.playingcards.util.UnitChatMessage;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class TileEntityBase
extends BlockEntity {
    public TileEntityBase(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    protected UnitChatMessage getUnitName(Player player) {
        return new UnitChatMessage(this.getLocation().getBlock().getName().getString(), new Entity[]{player});
    }

    public Location getLocation() {
        return new Location(this.level, this.worldPosition);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(pkt.getTag(), lookupProvider);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        CompoundTag nbtTagCompound = new CompoundTag();
        if (this.level != null) {
            this.saveAdditional(nbtTagCompound, (HolderLookup.Provider)this.level.registryAccess());
        }
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, lookupProvider);
        return nbt;
    }

    public CompoundTag getPersistentData() {
        CompoundTag nbt = new CompoundTag();
        if (this.level != null) {
            this.saveAdditional(nbt, (HolderLookup.Provider)this.level.registryAccess());
        }
        return nbt;
    }
}

