/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.playingcards.util;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class Location {
    public final Level world;
    public final int x;
    public final int y;
    public final int z;
    private final BlockPos blockPos;

    public Location(Level world, BlockPos pos) {
        this(world, pos.getX(), pos.getY(), pos.getZ());
    }

    public Location(Level world, int x, int y, int z) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.blockPos = new BlockPos(x, y, z);
    }

    public Location(BlockEntity tileEntity) {
        this(tileEntity.getLevel(), tileEntity.getBlockPos().getX(), tileEntity.getBlockPos().getY(), tileEntity.getBlockPos().getZ());
    }

    public Location(Entity entity) {
        this(entity.level(), entity.getBlockX(), entity.getBlockY(), entity.getBlockZ());
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public BlockState getBlockState() {
        if (this.getBlockPos() == null) {
            return null;
        }
        return this.world.getBlockState(this.getBlockPos());
    }

    public Block getBlock() {
        if (this.getBlockState() == null) {
            return null;
        }
        return this.getBlockState().getBlock();
    }

    public BlockEntity getTileEntity() {
        return this.world.getBlockEntity(this.getBlockPos());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Location) {
            Location newLoc = (Location)obj;
            return this.world == newLoc.world && this.x == newLoc.x && this.y == newLoc.y && this.z == newLoc.z;
        }
        return super.equals(obj);
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }
}

