/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.playingcards.block;

import com.ombremoon.playingcards.block.base.BlockContainerBase;
import com.ombremoon.playingcards.init.InitTileEntityTypes;
import com.ombremoon.playingcards.tileentity.TileEntityPokerTable;
import com.ombremoon.playingcards.util.Location;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockPokerTable
extends BlockContainerBase {
    private static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    private static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    private static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    private static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    private static final BooleanProperty NORTHWEST = BooleanProperty.m_61465_((String)"northwest");
    private static final BooleanProperty NORTHEAST = BooleanProperty.m_61465_((String)"northeast");
    private static final BooleanProperty SOUTHWEST = BooleanProperty.m_61465_((String)"southwest");
    private static final BooleanProperty SOUTHEAST = BooleanProperty.m_61465_((String)"southeast");
    private static final VoxelShape AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public BlockPokerTable() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56736_).m_60978_(1.0f).m_60910_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTHWEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTHEAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTHWEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTHEAST, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        if (pPlacer instanceof Player) {
            Player player = (Player)pPlacer;
            Location location = new Location(pLevel, pPos);
            BlockEntity tileEntity = location.getTileEntity();
            if (tileEntity instanceof TileEntityPokerTable) {
                TileEntityPokerTable pokerTable = (TileEntityPokerTable)tileEntity;
                pokerTable.setOwner(player);
            }
        }
    }

    private boolean canConnectTo(LevelAccessor world, BlockPos pos, int offX, int offZ) {
        BlockPos otherPos = pos.m_7918_(offX, 0, offZ);
        Block otherBlock = world.m_8055_(otherPos).m_60734_();
        return otherBlock instanceof BlockPokerTable;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return this.getState((LevelAccessor)pContext.m_43725_(), pContext.m_8083_());
    }

    private BlockState getState(LevelAccessor world, BlockPos pos) {
        boolean north = this.canConnectTo(world, pos, 0, -1);
        boolean east = this.canConnectTo(world, pos, 1, 0);
        boolean south = this.canConnectTo(world, pos, 0, 1);
        boolean west = this.canConnectTo(world, pos, -1, 0);
        boolean northwest = this.canConnectTo(world, pos, -1, -1);
        boolean northeast = this.canConnectTo(world, pos, 1, -1);
        boolean southwest = this.canConnectTo(world, pos, -1, 1);
        boolean southeast = this.canConnectTo(world, pos, 1, 1);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west))).m_61124_((Property)NORTHWEST, (Comparable)Boolean.valueOf(northwest))).m_61124_((Property)NORTHEAST, (Comparable)Boolean.valueOf(northeast))).m_61124_((Property)SOUTHWEST, (Comparable)Boolean.valueOf(southwest))).m_61124_((Property)SOUTHEAST, (Comparable)Boolean.valueOf(southeast));
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        return this.getState(pLevel, pCurrentPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{NORTH, SOUTH, EAST, WEST, NORTHWEST, NORTHEAST, SOUTHWEST, SOUTHEAST});
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AABB;
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AABB;
    }

    public boolean m_7420_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return true;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)InitTileEntityTypes.POKER_TABLE.get()).m_155264_(blockPos, blockState);
    }
}

