/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.playingcards.entity;

import com.ombremoon.playingcards.entity.base.EntityStacked;
import com.ombremoon.playingcards.init.InitEntityTypes;
import com.ombremoon.playingcards.init.InitItems;
import com.ombremoon.playingcards.util.ChatHelper;
import com.ombremoon.playingcards.util.ItemHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class EntityCardDeck
extends EntityStacked {
    private static final EntityDataAccessor<Float> ROTATION = SynchedEntityData.m_135353_(EntityCardDeck.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Byte> SKIN_ID = SynchedEntityData.m_135353_(EntityCardDeck.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public EntityCardDeck(EntityType<? extends EntityCardDeck> type, Level world) {
        super(type, world);
    }

    public EntityCardDeck(Level world, Vec3 position, float rotation, byte skinID) {
        super((EntityType<? extends EntityStacked>)((EntityType)InitEntityTypes.CARD_DECK.get()), world, position);
        this.createAndFillDeck();
        this.shuffleStack();
        this.f_19804_.m_135381_(ROTATION, (Object)Float.valueOf(rotation));
        this.f_19804_.m_135381_(SKIN_ID, (Object)skinID);
    }

    public float getRotation() {
        return ((Float)this.f_19804_.m_135370_(ROTATION)).floatValue();
    }

    public byte getSkinID() {
        return (Byte)this.f_19804_.m_135370_(SKIN_ID);
    }

    private void createAndFillDeck() {
        Byte[] newStack = new Byte[52];
        for (byte index = 0; index < 52; index = (byte)(index + 1)) {
            newStack[index] = index;
        }
        this.f_19804_.m_135381_(STACK, (Object)newStack);
    }

    public InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        if (pHand == InteractionHand.MAIN_HAND) {
            if (this.getStackAmount() > 0) {
                byte cardID = this.getTopStackID();
                ItemStack card = new ItemStack((ItemLike)InitItems.CARD_COVERED.get());
                card.m_41721_((int)cardID);
                ItemHelper.getNBT(card).m_128362_("UUID", this.m_20148_());
                ItemHelper.getNBT(card).m_128344_("SkinID", ((Byte)this.f_19804_.m_135370_(SKIN_ID)).byteValue());
                ItemHelper.getNBT(card).m_128379_("Covered", true);
                if (!this.m_9236_().f_46443_) {
                    ItemHelper.spawnStackAtEntity(this.m_9236_(), (Entity)pPlayer, card);
                }
                this.removeFromTop();
                return pPlayer.m_21205_().m_41619_() ? InteractionResult.SUCCESS : InteractionResult.FAIL;
            }
            if (this.m_9236_().f_46443_) {
                ChatHelper.printModMessage(ChatFormatting.RED, Component.m_237115_((String)"message.stack_empty"), new Entity[]{pPlayer});
            }
        }
        return InteractionResult.FAIL;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity entity = pSource.m_7640_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_6047_()) {
                ItemStack deck = new ItemStack((ItemLike)InitItems.CARD_DECK.get());
                ItemHelper.getNBT(deck).m_128344_("SkinID", ((Byte)this.f_19804_.m_135370_(SKIN_ID)).byteValue());
                ItemHelper.spawnStackAtEntity(this.m_9236_(), (Entity)player, deck);
                this.m_146870_();
            } else {
                this.shuffleStack();
                if (this.m_9236_().f_46443_) {
                    ChatHelper.printModMessage(ChatFormatting.GREEN, Component.m_237115_((String)"message.stack_shuffled"), new Entity[]{player});
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void moreData() {
        this.f_19804_.m_135372_(ROTATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SKIN_ID, (Object)0);
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.f_19804_.m_135381_(ROTATION, (Object)Float.valueOf(compoundTag.m_128457_("Rotation")));
        this.f_19804_.m_135381_(SKIN_ID, (Object)compoundTag.m_128445_("SkinID"));
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128350_("Rotation", ((Float)this.f_19804_.m_135370_(ROTATION)).floatValue());
        compoundTag.m_128344_("SkinID", ((Byte)this.f_19804_.m_135370_(SKIN_ID)).byteValue());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

