/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.playingcards.entity;

import com.ombremoon.playingcards.entity.base.EntityStacked;
import com.ombremoon.playingcards.init.InitEntityTypes;
import com.ombremoon.playingcards.init.InitItems;
import com.ombremoon.playingcards.item.ItemPokerChip;
import com.ombremoon.playingcards.util.ChatHelper;
import com.ombremoon.playingcards.util.ItemHelper;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class EntityPokerChip
extends EntityStacked {
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(EntityPokerChip.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<String> OWNER_NAME = SynchedEntityData.m_135353_(EntityPokerChip.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public EntityPokerChip(EntityType<? extends EntityPokerChip> type, Level world) {
        super(type, world);
    }

    public EntityPokerChip(Level world, Vec3 position, UUID ownerID, String ownerName, byte firstChipID) {
        super((EntityType<? extends EntityStacked>)((EntityType)InitEntityTypes.POKER_CHIP.get()), world, position);
        this.createStack();
        this.addToTop(firstChipID);
        this.f_19804_.m_135381_(OWNER_UUID, Optional.of(ownerID));
        this.f_19804_.m_135381_(OWNER_NAME, (Object)ownerName);
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).isPresent() ? (UUID)((Optional)this.f_19804_.m_135370_(OWNER_UUID)).get() : null;
    }

    private void takeChip(Player player) {
        byte chipID = this.getTopStackID();
        if (!this.m_9236_().f_46443_) {
            this.spawnChip(player, ItemPokerChip.getPokerChip(chipID), 1);
        }
        this.removeFromTop();
        if (this.getStackAmount() <= 0) {
            this.m_146870_();
        }
    }

    public InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        ItemStack stack = pPlayer.m_21120_(pHand);
        if (stack.m_41720_() instanceof ItemPokerChip) {
            CompoundTag nbt = ItemHelper.getNBT(stack);
            if (nbt.m_128403_("OwnerID")) {
                UUID ownerID = nbt.m_128342_("OwnerID");
                if (ownerID.equals(this.getOwnerUUID())) {
                    if (pPlayer.m_6047_()) {
                        while (this.getStackAmount() < 52 && stack.m_41613_() > 0) {
                            ItemPokerChip chip = (ItemPokerChip)stack.m_41720_();
                            this.addToTop(chip.getChipID());
                            stack.m_41774_(1);
                        }
                    } else if (this.getStackAmount() < 52) {
                        ItemPokerChip chip = (ItemPokerChip)stack.m_41720_();
                        this.addToTop(chip.getChipID());
                        stack.m_41774_(1);
                    } else if (this.m_9236_().f_46443_) {
                        ChatHelper.printModMessage(ChatFormatting.RED, Component.m_237115_((String)"message.stack_full"), new Entity[]{pPlayer});
                    }
                } else if (this.m_9236_().f_46443_) {
                    ChatHelper.printModMessage(ChatFormatting.RED, Component.m_237115_((String)"message.stack_owner_error"), new Entity[]{pPlayer});
                }
            }
        } else {
            this.takeChip(pPlayer);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity entity = pSource.m_7640_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int whiteAmount = 0;
            int redAmount = 0;
            int blueAmount = 0;
            int greenAmount = 0;
            int blackAmount = 0;
            for (int i = 0; i < ((Byte[])this.f_19804_.m_135370_(STACK)).length; ++i) {
                byte chipID = this.getIDAt(i);
                if (chipID == 0) {
                    ++whiteAmount;
                }
                if (chipID == 1) {
                    ++redAmount;
                }
                if (chipID == 2) {
                    ++blueAmount;
                }
                if (chipID == 3) {
                    ++greenAmount;
                }
                if (chipID != 4) continue;
                ++blackAmount;
            }
            if (whiteAmount > 0) {
                this.spawnChip(player, (Item)InitItems.POKER_CHIP_WHITE.get(), whiteAmount);
            }
            if (redAmount > 0) {
                this.spawnChip(player, (Item)InitItems.POKER_CHIP_RED.get(), redAmount);
            }
            if (blueAmount > 0) {
                this.spawnChip(player, (Item)InitItems.POKER_CHIP_BLUE.get(), blueAmount);
            }
            if (greenAmount > 0) {
                this.spawnChip(player, (Item)InitItems.POKER_CHIP_GREEN.get(), greenAmount);
            }
            if (blackAmount > 0) {
                this.spawnChip(player, (Item)InitItems.POKER_CHIP_BLACK.get(), blackAmount);
            }
            this.m_146870_();
            return false;
        }
        return true;
    }

    private void spawnChip(Player player, Item item, int amount) {
        if (!this.m_9236_().f_46443_) {
            ItemStack chip = new ItemStack((ItemLike)item, amount);
            CompoundTag nbt = ItemHelper.getNBT(chip);
            nbt.m_128362_("OwnerID", this.getOwnerUUID());
            nbt.m_128359_("OwnerName", (String)this.f_19804_.m_135370_(OWNER_NAME));
            ItemHelper.spawnStackAtEntity(this.m_9236_(), (Entity)player, chip);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Vec3 pos = this.m_20182_();
        double size = 0.1;
        double addAmount = 0.01575;
        this.m_20011_(new AABB(pos.f_82479_ - size, pos.f_82480_, pos.f_82481_ - size, pos.f_82479_ + size, pos.f_82480_ + 0.02 + addAmount * (double)this.getStackAmount(), pos.f_82481_ + size));
    }

    @Override
    public void moreData() {
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(OWNER_NAME, (Object)"");
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.f_19804_.m_135381_(OWNER_UUID, Optional.of(compoundTag.m_128342_("OwnerID")));
        this.f_19804_.m_135381_(OWNER_NAME, (Object)compoundTag.m_128461_("OwnerName"));
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128362_("OwnerID", this.getOwnerUUID());
        compoundTag.m_128359_("OwnerName", (String)this.f_19804_.m_135370_(OWNER_NAME));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

