/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.playingcards.item;

import com.ombremoon.playingcards.entity.EntityPokerChip;
import com.ombremoon.playingcards.init.InitItems;
import com.ombremoon.playingcards.item.base.ItemBase;
import com.ombremoon.playingcards.tileentity.TileEntityPokerTable;
import com.ombremoon.playingcards.util.ItemHelper;
import com.ombremoon.playingcards.util.Location;
import com.ombremoon.playingcards.util.StringHelper;
import com.ombremoon.playingcards.util.UnitChatMessage;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class ItemPokerChip
extends ItemBase {
    private final byte chipID;
    private final int value;

    public ItemPokerChip(byte chipID, int value) {
        super(new Item.Properties());
        this.chipID = chipID;
        this.value = value;
    }

    private UnitChatMessage getUnitMessage(Player ... players) {
        return new UnitChatMessage("poker_chip", (Entity[])players);
    }

    public byte getChipID() {
        return this.chipID;
    }

    public static Item getPokerChip(byte pokerChipID) {
        switch (pokerChipID) {
            case 1: {
                return (Item)InitItems.POKER_CHIP_RED.get();
            }
            case 2: {
                return (Item)InitItems.POKER_CHIP_BLUE.get();
            }
            case 3: {
                return (Item)InitItems.POKER_CHIP_GREEN.get();
            }
            case 4: {
                return (Item)InitItems.POKER_CHIP_BLACK.get();
            }
        }
        return (Item)InitItems.POKER_CHIP_WHITE.get();
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        CompoundTag nbt = ItemHelper.getNBT(pStack);
        if (nbt.m_128403_("OwnerID")) {
            pTooltipComponents.add((Component)Component.m_237113_((String)(ChatFormatting.GRAY + "Owner: " + ChatFormatting.GOLD + nbt.m_128461_("OwnerName"))));
        } else {
            pTooltipComponents.add((Component)Component.m_237113_((String)(ChatFormatting.GRAY + "Owner: " + ChatFormatting.GOLD + "Not set")));
        }
        pTooltipComponents.add((Component)Component.m_237113_((String)(ChatFormatting.GRAY + "Value (1): " + ChatFormatting.GOLD + this.value)));
        if (pStack.m_41613_() > 1) {
            pTooltipComponents.add((Component)Component.m_237113_((String)(ChatFormatting.GRAY + "Value (" + pStack.m_41613_() + "): " + ChatFormatting.GOLD + StringHelper.printCommas(this.value * pStack.m_41613_()))));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack heldItem = pPlayer.m_21120_(pUsedHand);
        if (pPlayer.m_6047_()) {
            UnitChatMessage unitMessage = this.getUnitMessage(pPlayer);
            CompoundTag nbt = ItemHelper.getNBT(heldItem);
            if (!nbt.m_128403_("OwnerID")) {
                nbt.m_128362_("OwnerID", pPlayer.m_20148_());
                nbt.m_128359_("OwnerName", pPlayer.m_5446_().getString());
                if (pLevel.f_46443_) {
                    unitMessage.printMessage(ChatFormatting.GREEN, Component.m_237115_((String)"message.poker_chip_owner_set"));
                }
            } else if (pLevel.f_46443_) {
                unitMessage.printMessage(ChatFormatting.RED, Component.m_237115_((String)"message.poker_chip_owner_error"));
            }
            return InteractionResultHolder.m_19090_((Object)heldItem);
        }
        return InteractionResultHolder.m_19100_((Object)heldItem);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Player player = pContext.m_43723_();
        if (player != null && !player.m_6047_()) {
            Level world = pContext.m_43725_();
            Location location = new Location(world, pContext.m_8083_());
            UnitChatMessage unitMessage = this.getUnitMessage(player);
            CompoundTag nbt = ItemHelper.getNBT(pContext.m_43722_());
            if (nbt.m_128403_("OwnerID")) {
                TileEntityPokerTable pokerTable;
                BlockEntity tileEntity;
                UUID ownerID = nbt.m_128342_("OwnerID");
                String ownerName = nbt.m_128461_("OwnerName");
                if (location.getBlockState().m_155947_() && (tileEntity = location.getTileEntity()) instanceof TileEntityPokerTable && !ownerID.equals((pokerTable = (TileEntityPokerTable)tileEntity).getOwnerID())) {
                    if (world.f_46443_) {
                        unitMessage.printMessage(ChatFormatting.RED, Component.m_237115_((String)"message.poker_chip_table_error"));
                    }
                    return InteractionResult.PASS;
                }
                EntityPokerChip chip = new EntityPokerChip(world, pContext.m_43720_(), ownerID, ownerName, this.chipID);
                world.m_7967_((Entity)chip);
                pContext.m_43722_().m_41774_(1);
            } else if (world.f_46443_) {
                unitMessage.printMessage(ChatFormatting.RED, Component.m_237115_((String)"message.poker_chip_owner_missing"));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

