/*
 * Decompiled with CFR 0.152.
 */
package lucie.deathtaxes.client.particle;

import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class FlyParticle
extends TextureSheetParticle {
    public FlyParticle(ClientLevel level, double x, double y, double z, double zSpeed, double ySpeed, double xSpeed) {
        super(level, x, y, z, zSpeed, ySpeed, xSpeed);
        this.speedUpWhenYMotionIsBlocked = true;
        this.friction = 0.96f;
        this.quadSize *= 0.75f;
        this.xd *= 0.8;
        this.yd *= 0.8;
        this.zd *= 0.8;
    }

    @Nonnull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        super.tick();
        if (!this.level.getBlockState(BlockPos.containing((double)this.x, (double)this.y, (double)this.z)).isAir()) {
            this.remove();
        } else if (Math.random() > (double)0.95f || this.age == 1) {
            this.setParticleSpeed((double)-0.05f + (double)0.1f * Math.random(), (double)-0.05f + (double)0.1f * Math.random(), (double)-0.05f + (double)0.1f * Math.random());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FlyProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public FlyProvider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(@Nonnull SimpleParticleType simpleParticleType, @Nonnull ClientLevel clientLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FlyParticle particle = new FlyParticle(clientLevel, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.pickSprite(this.sprite);
            particle.setLifetime(clientLevel.random.nextIntBetweenInclusive(36, 180));
            particle.scale(1.5f);
            return particle;
        }
    }
}

