/*
 * Decompiled with CFR 0.152.
 */
package lucie.deathtaxes.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import lucie.deathtaxes.DeathTaxes;
import lucie.deathtaxes.client.model.ScavengerModel;
import lucie.deathtaxes.client.renderer.DisplayItemArmLayer;
import lucie.deathtaxes.client.state.ScavengerRenderState;
import lucie.deathtaxes.entity.Scavenger;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;

public class ScavengerRenderer
extends MobRenderer<Scavenger, ScavengerRenderState, ScavengerModel<ScavengerRenderState>> {
    public ScavengerRenderer(EntityRendererProvider.Context context) {
        super(context, new ScavengerModel(context.bakeLayer(ScavengerModel.LAYER_LOCATION)), 0.5f);
        this.addLayer(new DisplayItemArmLayer((RenderLayerParent<ScavengerRenderState, ScavengerModel<ScavengerRenderState>>)this));
        this.addLayer((RenderLayer)new ItemInHandLayer<ScavengerRenderState, ScavengerModel<ScavengerRenderState>>(this, (RenderLayerParent)this){

            public void render(@Nonnull PoseStack poseStack, @Nonnull MultiBufferSource multiBufferSource, int packedLight, @Nonnull ScavengerRenderState renderState, float xRot, float yRot) {
                if (renderState.isAggressive) {
                    super.render(poseStack, multiBufferSource, packedLight, (ArmedEntityRenderState)renderState, xRot, yRot);
                }
            }
        });
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull ScavengerRenderState renderState) {
        return DeathTaxes.withModNamespace("textures/entity/scavenger.png");
    }

    @Nonnull
    public ScavengerRenderState createRenderState() {
        return new ScavengerRenderState();
    }

    public void extractRenderState(@Nonnull Scavenger scavenger, @Nonnull ScavengerRenderState renderState, float partialTick) {
        super.extractRenderState((LivingEntity)scavenger, (LivingEntityRenderState)renderState, partialTick);
        ArmedEntityRenderState.extractArmedEntityRenderState((LivingEntity)scavenger, (ArmedEntityRenderState)renderState, (ItemModelResolver)this.itemModelResolver);
        this.itemModelResolver.updateForLiving(renderState.displayItem, scavenger.getDisplayItem(), ItemDisplayContext.GROUND, (LivingEntity)scavenger);
        renderState.mainArm = scavenger.getMainArm();
        renderState.attackAnim = scavenger.getAttackAnim(partialTick);
        renderState.isAggressive = scavenger.isAggressive();
        renderState.isUnhappy = scavenger.unhappyCounter > scavenger.level().getGameTime();
        renderState.isHandsRaised = scavenger.handCounter > scavenger.level().getGameTime();
    }
}

