/*
 * Decompiled with CFR 0.152.
 */
package lucie.deathtaxes.entity.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import lucie.deathtaxes.entity.Scavenger;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;

public class AdvertisePlayerLoot
extends Behavior<Scavenger> {
    private ItemStack playerItemStack;
    private final List<ItemStack> displayItems = Lists.newArrayList();
    private int lookTime;
    private int cycleCounter;
    private int displayIndex;

    public AdvertisePlayerLoot(int minDuration, int maxDuration) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.INTERACTION_TARGET, (Object)MemoryStatus.VALUE_PRESENT), minDuration, maxDuration);
    }

    protected boolean checkExtraStartConditions(@Nonnull ServerLevel level, @Nonnull Scavenger owner) {
        Brain<Scavenger> brain = owner.getBrain();
        if (brain.getMemory(MemoryModuleType.INTERACTION_TARGET).isPresent()) {
            LivingEntity livingEntity = (LivingEntity)brain.getMemory(MemoryModuleType.INTERACTION_TARGET).get();
            return livingEntity.getType() == EntityType.PLAYER && owner.isAlive() && livingEntity.isAlive() && !owner.isAggressive() && owner.distanceToSqr((Entity)livingEntity) <= 17.0 && owner.getTradingPlayer() == null;
        }
        return false;
    }

    protected boolean canStillUse(@Nonnull ServerLevel level, @Nonnull Scavenger entity, long gameTime) {
        return this.checkExtraStartConditions(level, entity) && this.lookTime > 0 && entity.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).isPresent();
    }

    protected void start(@Nonnull ServerLevel level, @Nonnull Scavenger entity, long gameTime) {
        super.start(level, (LivingEntity)entity, gameTime);
        this.lookAtTarget(entity);
        this.cycleCounter = 0;
        this.displayIndex = 0;
        this.lookTime = 40;
    }

    protected void tick(@Nonnull ServerLevel level, @Nonnull Scavenger owner, long gameTime) {
        LivingEntity livingEntity = this.lookAtTarget(owner);
        this.findItemsToDisplay(livingEntity, owner);
        if (!this.displayItems.isEmpty()) {
            this.displayCyclingItems(owner);
        } else {
            this.setDisplayItem(owner, ItemStack.EMPTY);
            this.lookTime = Math.min(this.lookTime, 40);
        }
        --this.lookTime;
    }

    protected void stop(@Nonnull ServerLevel level, @Nonnull Scavenger entity, long gameTime) {
        super.stop(level, (LivingEntity)entity, gameTime);
        entity.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
        this.setDisplayItem(entity, ItemStack.EMPTY);
        this.playerItemStack = null;
    }

    private void findItemsToDisplay(LivingEntity entity, Scavenger scavenger) {
        boolean flag = false;
        ItemStack itemstack = entity.getMainHandItem();
        if (this.playerItemStack == null || !ItemStack.isSameItem((ItemStack)this.playerItemStack, (ItemStack)itemstack)) {
            this.playerItemStack = itemstack;
            flag = true;
            this.displayItems.clear();
        }
        if (flag && !this.playerItemStack.isEmpty()) {
            scavenger.getOffers().stream().filter(merchantOffer -> !merchantOffer.isOutOfStock()).filter(merchantOffer -> ItemStack.isSameItem((ItemStack)merchantOffer.getCostA(), (ItemStack)this.playerItemStack) || ItemStack.isSameItem((ItemStack)merchantOffer.getCostB(), (ItemStack)this.playerItemStack)).forEach(merchantOffer -> this.displayItems.add(merchantOffer.assemble()));
            if (!this.displayItems.isEmpty()) {
                this.lookTime = 900;
                this.setDisplayItem(scavenger, this.displayItems.getFirst());
            }
        }
    }

    private void setDisplayItem(Scavenger scavenger, ItemStack itemStack) {
        scavenger.setDisplayItem(itemStack);
    }

    private LivingEntity lookAtTarget(Scavenger scavenger) {
        Brain<Scavenger> brain = scavenger.getBrain();
        LivingEntity livingentity = (LivingEntity)brain.getMemory(MemoryModuleType.INTERACTION_TARGET).get();
        brain.setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)livingentity, true));
        return livingentity;
    }

    private void displayCyclingItems(Scavenger scavenger) {
        if (this.displayItems.size() >= 2 && ++this.cycleCounter >= 40) {
            ++this.displayIndex;
            this.cycleCounter = 0;
            if (this.displayIndex > this.displayItems.size() - 1) {
                this.displayIndex = 0;
            }
            this.setDisplayItem(scavenger, this.displayItems.get(this.displayIndex));
        }
    }
}

