/*
 * Decompiled with CFR 0.152.
 */
package lucie.deathtaxes.entity.behavior;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import lucie.deathtaxes.entity.Scavenger;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableLong;

public class MoveAroundPoint {
    public static OneShot<Scavenger> create(MemoryModuleType<GlobalPos> poiMemory, float speedModifier, int maxDistFromPoi) {
        MutableLong nextStrollTime = new MutableLong(0L);
        return BehaviorBuilder.create(context -> context.group((App)context.registered(MemoryModuleType.WALK_TARGET), (App)context.present(poiMemory)).apply((Applicative)context, (walkTargetAccessor, poiAccessor) -> (level, entity, gameTime) -> {
            if (entity.getTradingPlayer() != null) {
                return false;
            }
            GlobalPos poi = (GlobalPos)context.get(poiAccessor);
            if (!level.dimension().equals(poi.dimension())) {
                return false;
            }
            double distSqr = entity.blockPosition().distSqr((Vec3i)poi.pos());
            if (distSqr > (double)(maxDistFromPoi * maxDistFromPoi)) {
                walkTargetAccessor.set((Object)new WalkTarget(poi.pos(), speedModifier, 1));
            } else if (gameTime >= nextStrollTime.getValue()) {
                Optional<Vec3> randomPos = Optional.ofNullable(LandRandomPos.getPos((PathfinderMob)entity, (int)8, (int)6));
                randomPos.ifPresent(pos -> walkTargetAccessor.set((Object)new WalkTarget(pos, speedModifier, 1)));
                nextStrollTime.setValue(gameTime + 180L);
            }
            return true;
        }));
    }
}

