/*
 * Decompiled with CFR 0.152.
 */
package lucie.deathtaxes.event.hooks;

import java.util.Collection;
import java.util.Optional;
import lucie.deathtaxes.DeathTaxes;
import lucie.deathtaxes.entity.Scavenger;
import lucie.deathtaxes.registry.AttachmentTypeRegistry;
import lucie.deathtaxes.registry.EntityTypeRegistry;
import lucie.deathtaxes.utility.ItemEvaluation;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.Heightmap;

public class PlayerHooks {
    public static boolean collectDrops(ServerLevel level, ServerPlayer player, Collection<ItemEntity> drops) {
        if (!((GameRules.BooleanValue)level.getServer().getGameRules().getRule(GameRules.RULE_KEEPINVENTORY)).get() && !drops.isEmpty()) {
            TagKey blacklist = ItemTags.create((ResourceLocation)DeathTaxes.withModNamespace("blacklisted_loot"));
            ItemContainerContents contents = ItemContainerContents.fromItems(drops.stream().map(ItemEntity::getItem).filter(item -> !item.is(blacklist)).toList());
            if (contents != ItemContainerContents.EMPTY) {
                player.setData(AttachmentTypeRegistry.PLAYER_INVENTORY_DROPS, (Object)contents);
            }
            return true;
        }
        return false;
    }

    public static void copyDrops(Player original, Player current, boolean isDeath) {
        ItemContainerContents contents = (ItemContainerContents)original.getData(AttachmentTypeRegistry.PLAYER_INVENTORY_DROPS);
        if (!contents.equals((Object)ItemContainerContents.EMPTY) && isDeath) {
            current.setData(AttachmentTypeRegistry.PLAYER_INVENTORY_DROPS, (Object)contents);
        }
    }

    public static void checkDrops(ServerLevel level, ServerPlayer player) {
        ItemContainerContents contents = (ItemContainerContents)player.getData(AttachmentTypeRegistry.PLAYER_INVENTORY_DROPS);
        if (!contents.equals((Object)ItemContainerContents.EMPTY)) {
            PlayerHooks.spawn(player, level, contents);
            player.removeData(AttachmentTypeRegistry.PLAYER_INVENTORY_DROPS);
        }
    }

    private static void spawn(ServerPlayer player, ServerLevel level, ItemContainerContents contents) {
        MerchantOffers offers = ItemEvaluation.evaluateItems(player, level, contents);
        if (!offers.isEmpty()) {
            BlockPos target = player.blockPosition();
            BlockPos spawnpoint = PlayerHooks.locate((LevelReader)level, target, level.random).orElse(target);
            Optional.ofNullable((Scavenger)((EntityType)EntityTypeRegistry.SCAVENGER.value()).spawn(level, spawnpoint, EntitySpawnReason.TRIGGERED)).ifPresent(scavenger -> {
                scavenger.merchantOffers = offers;
                scavenger.setHomeTo(target, 16);
            });
        }
    }

    private static Optional<BlockPos> locate(LevelReader level, BlockPos blockPos, RandomSource randomSource) {
        SpawnPlacementType spawnPlacementType = SpawnPlacements.getPlacementType((EntityType)((EntityType)EntityTypeRegistry.SCAVENGER.value()));
        for (int i = 0; i < 16; ++i) {
            int z;
            int y;
            int x = blockPos.getX() + randomSource.nextInt(64) - 32;
            BlockPos randomPos = new BlockPos(x, y = level.getHeight(Heightmap.Types.WORLD_SURFACE, x, z = blockPos.getZ() + randomSource.nextInt(64) - 32), z);
            if (!spawnPlacementType.isSpawnPositionOk(level, randomPos, (EntityType)EntityTypeRegistry.SCAVENGER.value()) || !PlayerHooks.accessible((BlockGetter)level, randomPos)) continue;
            return Optional.of(randomPos);
        }
        return Optional.empty();
    }

    private static boolean accessible(BlockGetter level, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos, (BlockPos)pos.offset(1, 2, 1))) {
            if (level.getBlockState(blockpos).getCollisionShape(level, blockpos).isEmpty()) continue;
            return false;
        }
        return true;
    }
}

