/*
 * Decompiled with CFR 0.152.
 */
package lucie.deathtaxes.entity;

import com.mojang.serialization.Dynamic;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lucie.deathtaxes.entity.ScavengerAi;
import lucie.deathtaxes.registry.ParticleTypeRegistry;
import lucie.deathtaxes.registry.SoundEventRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class Scavenger
extends PathfinderMob
implements Merchant {
    @Nullable
    private Player tradingPlayer;
    @Nullable
    public MerchantOffers merchantOffers;
    public long unhappyCounter;
    public long handCounter;
    public long despawnDelay;
    public static final EntityDataAccessor<ItemStack> DATA_DISPLAY_ITEM = SynchedEntityData.defineId(Scavenger.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);

    public Scavenger(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 10;
    }

    @Nonnull
    protected Brain.Provider<?> brainProvider() {
        return Brain.provider(ScavengerAi.MEMORY_TYPES, ScavengerAi.SENSOR_TYPES);
    }

    @Nonnull
    protected Brain<?> makeBrain(@Nonnull Dynamic<?> dynamic) {
        return ScavengerAi.makeBrain(this, (Brain<Scavenger>)this.brainProvider().makeBrain(dynamic));
    }

    @Nonnull
    public Brain<Scavenger> getBrain() {
        return super.getBrain();
    }

    public static AttributeSupplier registerAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.35f).add(Attributes.FOLLOW_RANGE, 12.0).add(Attributes.MAX_HEALTH, 24.0).add(Attributes.ATTACK_DAMAGE, 0.5).build();
    }

    protected void customServerAiStep(@Nonnull ServerLevel level) {
        ProfilerFiller profilerfiller = Profiler.get();
        profilerfiller.push("scavengerBrain");
        this.getBrain().tick(level, (LivingEntity)this);
        profilerfiller.popPush("scavengerActivityUpdate");
        ScavengerAi.updateActivity(this);
        profilerfiller.pop();
    }

    public void aiStep() {
        super.aiStep();
        this.updateSwingTime();
    }

    public void handleEntityEvent(byte id) {
        super.handleEntityEvent(id);
        if (id == 22) {
            double x = this.getX() + this.random.nextDouble() * 5.0 - 2.5;
            double y = this.getY() + this.random.nextDouble() * 2.5;
            double z = this.getZ() + this.random.nextDouble() * 5.0 - 2.5;
            this.level().addParticle((ParticleOptions)((SimpleParticleType)ParticleTypeRegistry.FLY.get()), x, y, z, 0.0, 0.0, 0.0);
            if (this.random.nextInt(8) == 0) {
                this.level().playLocalSound((Entity)this, (SoundEvent)SoundEventRegistry.FLIES_BUZZING.value(), SoundSource.NEUTRAL, 0.25f, 1.0f);
            }
        } else if (id == 23) {
            if (this.level().getGameTime() > this.unhappyCounter) {
                this.unhappyCounter = this.level().getGameTime() + 40L;
                this.ambientSoundTime = 0;
                this.level().playLocalSound((Entity)this, (SoundEvent)SoundEventRegistry.SCAVENGER_NO.value(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        } else if (id == 24) {
            super.handleEntityEvent((byte)60);
            this.level().playLocalSound((Entity)this, (SoundEvent)SoundEventRegistry.SOMETHING_TELEPORTS.value(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.level().playLocalSound((Entity)this, (SoundEvent)SoundEventRegistry.SCAVENGER_YES.value(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.handCounter = this.level().getGameTime() + 30L;
        }
    }

    public boolean canBeAffected(@Nonnull MobEffectInstance effectInstance) {
        return !MobEffects.WITHER.equals((Object)effectInstance.getEffect()) && super.canBeAffected(effectInstance);
    }

    public ItemStack getDisplayItem() {
        return (ItemStack)this.entityData.get(DATA_DISPLAY_ITEM);
    }

    public void setDisplayItem(ItemStack itemStack) {
        this.entityData.set(DATA_DISPLAY_ITEM, (Object)itemStack);
    }

    public boolean requiresCustomPersistence() {
        return this.merchantOffers != null && !this.merchantOffers.isEmpty() || super.requiresCustomPersistence();
    }

    public void checkDespawn() {
        if (this.requiresCustomPersistence()) {
            boolean shouldDespawn;
            boolean bl = shouldDespawn = this.merchantOffers != null && this.merchantOffers.stream().allMatch(MerchantOffer::isOutOfStock) || this.despawnDelay != 0L && this.level().getGameTime() > this.despawnDelay;
            if (shouldDespawn && this.tradingPlayer == null) {
                this.makeSound((SoundEvent)SoundEventRegistry.SOMETHING_TELEPORTS.value());
                this.level().broadcastEntityEvent((Entity)this, (byte)60);
                this.discard();
                return;
            }
        }
        super.checkDespawn();
    }

    public boolean doHurtTarget(@Nonnull ServerLevel serverLevel, @Nonnull Entity entity) {
        if (super.doHurtTarget(serverLevel, entity)) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                float duration = this.level().getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
                livingEntity.addEffect(new MobEffectInstance(MobEffects.WITHER, 140 * (int)duration), (Entity)this);
            }
            return true;
        }
        return false;
    }

    public boolean hurtServer(@Nonnull ServerLevel serverLevel, @Nonnull DamageSource damageSource, float amount) {
        if (super.hurtServer(serverLevel, damageSource, amount)) {
            LivingEntity livingEntity;
            Entity entity = damageSource.getEntity();
            if (entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).hasInfiniteMaterials()) {
                this.brain.setMemory(MemoryModuleType.ANGRY_AT, (Object)livingEntity.getUUID());
                this.brain.setMemory(MemoryModuleType.ATTACK_TARGET, (Object)livingEntity);
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public InteractionResult mobInteract(@Nonnull Player player, @Nonnull InteractionHand hand) {
        if (this.isAlive() && !this.isAggressive() && !this.isInvisible() && this.tradingPlayer == null) {
            if (!this.level().isClientSide) {
                if (this.getOffers().isEmpty()) {
                    this.level().broadcastEntityEvent((Entity)this, (byte)23);
                } else {
                    this.setTradingPlayer(player);
                    this.openTradingScreen(player, this.getDisplayName(), 0);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    @Nullable
    protected SoundEvent getHurtSound(@Nonnull DamageSource damageSource) {
        return (SoundEvent)SoundEventRegistry.SCAVENGER_HURT.value();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundEventRegistry.SCAVENGER_AMBIENT.value();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundEventRegistry.SCAVENGER_DEATH.value();
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@Nonnull ServerLevelAccessor level, @Nonnull DifficultyInstance difficulty, @Nonnull EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnGroupData) {
        this.populateDefaultEquipmentSlots(this.random, difficulty);
        this.populateDefaultEquipmentEnchantments(level, this.random, difficulty);
        if (spawnReason == EntitySpawnReason.TRIGGERED) {
            this.despawnDelay = this.level().getGameTime() + 24000L;
            this.getBrain().setMemory(MemoryModuleType.DANCING, (Object)true);
        } else {
            this.restrictTo(this.blockPosition(), 16);
        }
        return super.finalizeSpawn(level, difficulty, spawnReason, spawnGroupData);
    }

    protected void populateDefaultEquipmentSlots(@Nonnull RandomSource randomSource, @Nonnull DifficultyInstance difficultyInstance) {
        super.populateDefaultEquipmentSlots(randomSource, difficultyInstance);
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_SHOVEL));
    }

    protected void defineSynchedData(@Nonnull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_DISPLAY_ITEM, (Object)ItemStack.EMPTY);
    }

    public void addAdditionalSaveData(@Nonnull CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putLong("DespawnDelay", this.despawnDelay);
        compoundTag.storeNullable("MerchantOffers", MerchantOffers.CODEC, (Object)this.merchantOffers);
    }

    public void readAdditionalSaveData(@Nonnull CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.despawnDelay = compoundTag.getLongOr("DespawnDelay", 0L);
        this.merchantOffers = compoundTag.read("MerchantOffers", MerchantOffers.CODEC).orElse(null);
    }

    public void setTradingPlayer(@Nullable Player player) {
        this.tradingPlayer = player;
    }

    @Nullable
    public Player getTradingPlayer() {
        return this.tradingPlayer;
    }

    @Nonnull
    public MerchantOffers getOffers() {
        return this.merchantOffers != null ? this.merchantOffers : new MerchantOffers();
    }

    public void overrideOffers(@Nonnull MerchantOffers merchantOffers) {
        this.merchantOffers = merchantOffers;
    }

    public void notifyTrade(@Nonnull MerchantOffer merchantOffer) {
        merchantOffer.increaseUses();
        if (merchantOffer.shouldRewardExp()) {
            this.level().addFreshEntity((Entity)new ExperienceOrb(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), merchantOffer.getXp()));
        }
    }

    public void notifyTradeUpdated(@Nonnull ItemStack itemStack) {
        if (!this.level().isClientSide && this.ambientSoundTime > -this.getAmbientSoundInterval() + 20) {
            this.ambientSoundTime = -this.getAmbientSoundInterval();
            this.makeSound(itemStack.isEmpty() ? (SoundEvent)SoundEventRegistry.SCAVENGER_NO.value() : (SoundEvent)SoundEventRegistry.SCAVENGER_YES.value());
        }
    }

    @Nonnull
    public SoundEvent getNotifyTradeSound() {
        return (SoundEvent)SoundEventRegistry.SCAVENGER_TRADE.value();
    }

    public boolean isClientSide() {
        return this.level().isClientSide;
    }

    public boolean stillValid(@Nonnull Player player) {
        return this.getTradingPlayer() == player && this.isAlive() && player.canInteractWithEntity((Entity)this, 4.0);
    }

    public int getVillagerXp() {
        return 0;
    }

    public void overrideXp(int i) {
    }

    public boolean showProgressBar() {
        return false;
    }

    public boolean canBeLeashed() {
        return false;
    }

    public void restrictTo(@Nonnull BlockPos blockPos, int distance) {
        super.restrictTo(blockPos, distance);
        this.brain.setMemory(MemoryModuleType.HOME, (Object)GlobalPos.of((ResourceKey)this.level().dimension(), (BlockPos)blockPos));
    }
}

