/*
 * Decompiled with CFR 0.152.
 */
package lucie.deathtaxes.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import lucie.deathtaxes.DeathTaxes;
import lucie.deathtaxes.entity.Scavenger;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;

public class ScavengerModel
extends EntityModel<Scavenger>
implements ArmedModel,
HeadedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(DeathTaxes.withModNamespace("scavenger"), "main");
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart crossedArms;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public ScavengerModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("head");
        this.crossedArms = root.getChild("crossed_arms");
        this.rightArm = root.getChild("right_arm");
        this.leftArm = root.getChild("left_arm");
        this.rightLeg = root.getChild("right_leg");
        this.leftLeg = root.getChild("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(24, 0).addBox(-1.0f, -3.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(10.0f, -38.75f, -4.0f, 8.0f, 7.0f, 8.0f, new CubeDeformation(0.125f)).texOffs(28, 53).addBox(9.5f, -33.75f, -4.5f, 9.0f, 2.0f, 9.0f, new CubeDeformation(0.125f)), PartPose.offset((float)-14.0f, (float)24.75f, (float)0.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 18).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 36).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 20).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 20).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(28, 36).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(28, 36).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("crossed_arms", CubeListBuilder.create().texOffs(44, 20).addBox(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(44, 20).mirror().addBox(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(40, 32).addBox(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(@Nonnull Scavenger scavenger, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        long gameTime = scavenger.level().getGameTime();
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.rightArm.yRot = 0.0f;
        this.rightArm.zRot = 0.0f;
        this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        this.leftArm.yRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.rightLeg.yRot = 0.0f;
        this.rightLeg.zRot = 0.0f;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.leftLeg.yRot = 0.0f;
        this.leftLeg.zRot = 0.0f;
        if (scavenger.unhappyCounter > gameTime) {
            this.head.yRot += 0.3f * Mth.sin((float)(0.45f * ageInTicks));
            this.head.xRot = 0.2f;
        }
        if (scavenger.isAggressive() || scavenger.handCounter > gameTime) {
            this.leftArm.visible = true;
            this.rightArm.visible = true;
            this.crossedArms.visible = false;
            if (scavenger.isAggressive()) {
                if (scavenger.getMainHandItem().isEmpty()) {
                    AnimationUtils.animateZombieArms((ModelPart)this.leftArm, (ModelPart)this.rightArm, (boolean)true, (float)this.attackTime, (float)ageInTicks);
                } else {
                    AnimationUtils.swingWeaponDown((ModelPart)this.rightArm, (ModelPart)this.leftArm, (Mob)scavenger, (float)this.attackTime, (float)ageInTicks);
                }
            } else {
                this.rightArm.z = 0.0f;
                this.rightArm.x = -5.0f;
                this.leftArm.z = 0.0f;
                this.leftArm.x = 5.0f;
                this.rightArm.xRot = Mth.cos((float)(ageInTicks * 0.6662f)) * 0.25f;
                this.leftArm.xRot = Mth.cos((float)(ageInTicks * 0.6662f)) * 0.25f;
                this.rightArm.zRot = 2.3561945f;
                this.leftArm.zRot = -2.3561945f;
                this.rightArm.yRot = 0.0f;
                this.leftArm.yRot = 0.0f;
            }
        } else {
            this.leftArm.visible = false;
            this.rightArm.visible = false;
            this.crossedArms.visible = true;
            this.crossedArms.xRot = (float)Math.toRadians(-45.0);
        }
    }

    public void translateToArms(PoseStack poseStack) {
        this.root.translateAndRotate(poseStack);
        this.crossedArms.translateAndRotate(poseStack);
    }

    public void translateToHand(@Nonnull HumanoidArm humanoidArm, @Nonnull PoseStack poseStack) {
        this.root.translateAndRotate(poseStack);
        if (humanoidArm == HumanoidArm.LEFT) {
            this.leftArm.translateAndRotate(poseStack);
        } else {
            this.rightArm.translateAndRotate(poseStack);
        }
    }

    @Nonnull
    public ModelPart getHead() {
        return this.head;
    }

    public void renderToBuffer(@Nonnull PoseStack poseStack, @Nonnull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }
}

