/*
 * Decompiled with CFR 0.152.
 */
package lucie.deathtaxes.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import lucie.deathtaxes.client.model.ScavengerModel;
import lucie.deathtaxes.entity.Scavenger;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;

public class DisplayItemArmLayer
extends RenderLayer<Scavenger, ScavengerModel> {
    private final ItemInHandRenderer itemInHandRenderer;

    public DisplayItemArmLayer(RenderLayerParent<Scavenger, ScavengerModel> renderer, ItemInHandRenderer itemInHandRenderer) {
        super(renderer);
        this.itemInHandRenderer = itemInHandRenderer;
    }

    public void render(@Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int packedLight, @Nonnull Scavenger scavenger, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!scavenger.getDisplayItem().isEmpty() && !scavenger.isAggressive() && scavenger.level().getGameTime() > scavenger.handCounter) {
            poseStack.pushPose();
            ((ScavengerModel)this.getParentModel()).translateToArms(poseStack);
            poseStack.mulPose(Axis.XP.rotation(0.75f));
            poseStack.scale(1.07f, 1.07f, 1.07f);
            poseStack.translate(0.0f, 0.13f, -0.34f);
            poseStack.mulPose(Axis.XP.rotation((float)Math.PI));
            this.itemInHandRenderer.renderItem((LivingEntity)scavenger, scavenger.getDisplayItem(), ItemDisplayContext.GROUND, false, poseStack, bufferSource, packedLight);
            poseStack.popPose();
        }
    }
}

