/*
 * Decompiled with CFR 0.152.
 */
package lucie.deathtaxes.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lucie.deathtaxes.entity.Scavenger;
import lucie.deathtaxes.entity.behavior.AdvertisePlayerLoot;
import lucie.deathtaxes.entity.behavior.DramaticEntrance;
import lucie.deathtaxes.entity.behavior.FollowTradingPlayer;
import lucie.deathtaxes.entity.behavior.MoveAroundPoint;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetLookAndInteract;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class ScavengerAi {
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.INTERACTION_TARGET, (Object)MemoryModuleType.HOME, (Object)MemoryModuleType.ANGRY_AT, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryModuleType.DANCING);
    protected static final ImmutableList<SensorType<? extends Sensor<? super Scavenger>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.HURT_BY);

    protected static Brain<?> makeBrain(Scavenger scavenger, Brain<Scavenger> brain) {
        ScavengerAi.initCoreActivity(brain);
        ScavengerAi.initIdleActivity(brain);
        ScavengerAi.initFightActivity(brain, scavenger);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<Scavenger> brain) {
        brain.addActivity(Activity.CORE, ImmutableList.of((Object)Pair.of((Object)0, (Object)new Swim(0.8f)), (Object)Pair.of((Object)0, (Object)new LookAtTargetSink(45, 90)), (Object)Pair.of((Object)0, (Object)((Object)new DramaticEntrance())), (Object)Pair.of((Object)1, (Object)new MoveToTargetSink()), (Object)Pair.of((Object)4, (Object)((Object)new FollowTradingPlayer()))));
    }

    private static void initIdleActivity(Brain<Scavenger> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)2, (Object)SetEntityLookTarget.create((EntityType)EntityType.PLAYER, (float)8.0f)), (Object)Pair.of((Object)3, (Object)((Object)new AdvertisePlayerLoot(400, 1600))), (Object)Pair.of((Object)3, MoveAroundPoint.create((MemoryModuleType<GlobalPos>)MemoryModuleType.HOME, 0.75f, 16)), (Object)Pair.of((Object)3, (Object)SetLookAndInteract.create((EntityType)EntityType.PLAYER, (int)4)), (Object)Pair.of((Object)1, (Object)StartAttacking.create(Mob::isAggressive, ScavengerAi::findNearestValidAttackTarget))));
    }

    private static void initFightActivity(Brain<Scavenger> brain, Scavenger scavenger) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, ImmutableList.of((Object)MeleeAttack.create((int)20), (Object)StopAttackingIfTargetInvalid.create(livingEntity -> !ScavengerAi.isNearestValidAttackTarget(scavenger, livingEntity)), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.0f)), MemoryModuleType.ATTACK_TARGET);
    }

    public static void updateActivity(Scavenger scavenger) {
        scavenger.setAggressive(scavenger.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
        scavenger.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.IDLE));
    }

    public static Optional<? extends LivingEntity> findNearestValidAttackTarget(Scavenger scavenger) {
        Optional optionalEntity = BehaviorUtils.getLivingEntityFromUUIDMemory((LivingEntity)scavenger, (MemoryModuleType)MemoryModuleType.ANGRY_AT);
        if (optionalEntity.isPresent() && Sensor.isEntityAttackable((LivingEntity)scavenger, (LivingEntity)((LivingEntity)optionalEntity.get()))) {
            return optionalEntity;
        }
        return Optional.empty();
    }

    private static boolean isNearestValidAttackTarget(Scavenger scavenger, LivingEntity target) {
        return ScavengerAi.findNearestValidAttackTarget(scavenger).filter(livingEntity -> livingEntity == target).isPresent();
    }
}

